/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.io.OutputStream;
import java.util.HashMap;
import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.binding.notification.NotificationReferenceBindingProvider;
import org.apache.tuscany.sca.binding.notification.util.IOUtils;
import org.apache.tuscany.sca.implementation.notification.ImmutableMessage;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class NotificationReferenceBindingInvoker
implements Invoker {
    private static final Message RESPONSE = new ImmutableMessage();
    private Operation operation;
    private NotificationReferenceBindingProvider notificationReferenceBindingProvider;

    public NotificationReferenceBindingInvoker(Operation operation, NotificationReferenceBindingProvider notificationReferenceBindingProvider) {
        this.operation = operation;
        this.notificationReferenceBindingProvider = notificationReferenceBindingProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message invoke(Message msg) {
        Object payload = msg.getBody();
        if (payload == null) {
            throw new RuntimeException("Message body is null");
        }
        IOUtils.Writeable writeable = null;
        String incomingBrokerID = null;
        if (payload.getClass().isArray()) {
            Object[] bodyArray = (Object[])payload;
            if (bodyArray.length == 3) {
                writeable = this.getWriteableFromByteArray((byte[])bodyArray[1]);
                incomingBrokerID = (String)bodyArray[2];
            } else {
                if (bodyArray.length != 1) throw new RuntimeException("Invalid body array size");
                writeable = this.getWriteableFromPayload(bodyArray[0]);
            }
        } else {
            writeable = this.getWriteableFromPayload(payload);
        }
        try {
            for (NotificationReferenceBindingProvider.SubscriberInfo subscriber : this.notificationReferenceBindingProvider.getSubscribers()) {
                if (incomingBrokerID != null && subscriber.brokerID != null && incomingBrokerID.equals(subscriber.brokerID)) continue;
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("notification-operation", this.operation.getName());
                String brokerID = this.notificationReferenceBindingProvider.getBrokerID();
                if (brokerID != null) {
                    headers.put("brokerID", brokerID);
                }
                IOUtils.sendHttpRequest(subscriber.address, headers, writeable, null);
            }
            return RESPONSE;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Sender caught exception", e);
        }
    }

    private IOUtils.Writeable getWriteableFromPayload(Object payload) throws RuntimeException {
        if (!(payload instanceof OMElement)) {
            throw new RuntimeException("payload not OMElement");
        }
        final OMElement element = (OMElement)payload;
        IOUtils.Writeable writeable = new IOUtils.Writeable(){

            public void write(OutputStream os) throws IOUtils.IOUtilsException {
                try {
                    element.serialize(os);
                    os.flush();
                }
                catch (Exception e) {
                    throw new IOUtils.IOUtilsException(e);
                }
            }
        };
        return writeable;
    }

    private IOUtils.Writeable getWriteableFromByteArray(final byte[] payload) {
        IOUtils.Writeable writeable = new IOUtils.Writeable(){

            public void write(OutputStream os) throws IOUtils.IOUtilsException {
                try {
                    os.write(payload);
                    os.flush();
                }
                catch (Exception e) {
                    throw new IOUtils.IOUtilsException(e);
                }
            }
        };
        return writeable;
    }
}

