/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.notification;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.binding.notification.NotificationBinding;
import org.apache.tuscany.sca.binding.notification.NotificationBindingFactory;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationBindingProcessor
implements StAXArtifactProcessor<NotificationBinding> {
    protected static final QName BINDING_NOTIFICATION = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "binding.notification");
    private NotificationBindingFactory bindingFactory;

    public NotificationBindingProcessor(AssemblyFactory assemblyFactory, PolicyFactory policyFactory, NotificationBindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    @Override
    public QName getArtifactType() {
        return BINDING_NOTIFICATION;
    }

    @Override
    public Class<NotificationBinding> getModelType() {
        return NotificationBinding.class;
    }

    @Override
    public NotificationBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        assert (BINDING_NOTIFICATION.equals(reader.getName()));
        String bindingUri = reader.getAttributeValue(null, "uri");
        String name = reader.getAttributeValue(null, "name");
        String ntm = reader.getAttributeValue(null, "ntm");
        String notificationType = reader.getAttributeValue(null, "notificationType");
        NotificationBinding binding = this.bindingFactory.createNotificationBinding();
        if (name != null) {
            binding.setName(name);
        }
        if (bindingUri != null) {
            binding.setURI(bindingUri);
        }
        if (ntm != null) {
            binding.setNtmAddress(ntm);
        }
        if (notificationType != null) {
            try {
                binding.setNotificationType(new URI(notificationType));
            }
            catch (URISyntaxException e) {
                throw new ContributionReadException(e);
            }
        }
        return binding;
    }

    @Override
    public void write(NotificationBinding notificationBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
    }

    @Override
    public void resolve(NotificationBinding notificationBinding, ModelResolver resolver) throws ContributionResolveException {
    }
}

