/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import com.metaparadigm.jsonrpc.JSONRPCBridge;
import com.metaparadigm.jsonrpc.JSONRPCResult;
import com.metaparadigm.jsonrpc.JSONRPCServlet;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JavaToSmd;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONRPCServiceServlet
extends JSONRPCServlet {
    private static final long serialVersionUID = 1L;
    transient Binding binding;
    transient String serviceName;
    transient Object serviceInstance;
    transient RuntimeComponentService componentService;
    transient InterfaceContract serviceContract;
    transient Class<?> serviceInterface;

    public JSONRPCServiceServlet(Binding binding, RuntimeComponentService componentService, InterfaceContract serviceContract, Class<?> serviceInterface, Object serviceInstance) {
        this.binding = binding;
        this.serviceName = binding.getName();
        this.componentService = componentService;
        this.serviceContract = serviceContract;
        this.serviceInterface = serviceInterface;
        this.serviceInstance = serviceInstance;
    }

    public void init(ServletConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("smd".equals(request.getQueryString())) {
            this.handleSMDRequest(request, response);
        } else {
            try {
                this.handleServiceRequest(request, response);
            }
            finally {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.removeAttribute("JSONRPCBridge");
                }
            }
        }
    }

    private void handleServiceRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int ret;
        response.setContentType("text/plain;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        CharArrayWriter data = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((ret = in.read(buf, 0, 4096)) != -1) {
            data.write(buf, 0, ret);
        }
        JSONObject jsonReq = null;
        String method = null;
        try {
            jsonReq = new JSONObject(data.toString());
            method = jsonReq.getString("method");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse request", e);
        }
        byte[] bout = method.startsWith("system.") ? this.handleJSONRPCSystemInvocation(request, response, data.toString()) : this.handleJSONRPCMethodInvocation(request, response, jsonReq);
        out.write(bout);
        out.flush();
        out.close();
    }

    protected void handleSMDRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
        String serviceUrl = request.getRequestURL().toString();
        String smd = JavaToSmd.interfaceToSmd(this.serviceInterface, serviceUrl);
        response.setContentType("text/plain;charset=utf-8");
        ServletOutputStream out = response.getOutputStream();
        byte[] bout = smd.getBytes("UTF-8");
        out.write(bout);
        out.flush();
        out.close();
    }

    protected byte[] handleJSONRPCSystemInvocation(HttpServletRequest request, HttpServletResponse response, String requestData) throws IOException, UnsupportedEncodingException {
        HttpSession session = request.getSession();
        JSONRPCBridge jsonrpcBridge = new JSONRPCBridge();
        jsonrpcBridge.registerObject((Object)"Service", this.serviceInstance, this.serviceInterface);
        session.setAttribute("JSONRPCBridge", (Object)jsonrpcBridge);
        JSONObject jsonReq = null;
        JSONRPCResult jsonResp = null;
        try {
            jsonReq = new JSONObject(requestData);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse request", e);
        }
        String method = jsonReq.getString("method");
        if (method != null && method.indexOf(46) < 0) {
            jsonReq.putOpt("method", (Object)("Service." + method));
        }
        jsonResp = jsonrpcBridge.call(new Object[]{request}, jsonReq);
        return jsonResp.toString().getBytes("UTF-8");
    }

    protected byte[] handleJSONRPCMethodInvocation(HttpServletRequest request, HttpServletResponse response, JSONObject jsonReq) throws IOException, UnsupportedEncodingException {
        String method = null;
        Object[] args = null;
        Object id = null;
        try {
            method = jsonReq.getString("method");
            if (method != null && method.indexOf(46) < 0) {
                jsonReq.putOpt("method", (Object)("Service." + method));
            }
            JSONArray array = jsonReq.getJSONArray("params");
            args = new Object[array.length()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = array.get(i);
            }
            id = jsonReq.get("id");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find json method name", e);
        }
        RuntimeWire wire = this.componentService.getRuntimeWire(this.binding, this.serviceContract);
        Operation jsonOperation = this.findOperation(method);
        Object result = null;
        try {
            JSONObject jsonResponse = new JSONObject();
            result = wire.invoke(jsonOperation, args);
            try {
                jsonResponse.put("result", result);
                jsonResponse.putOpt("id", id);
                return jsonResponse.toString().getBytes("UTF-8");
            }
            catch (Exception e) {
                throw new ServiceRuntimeException("Unable to create JSON response", e);
            }
        }
        catch (InvocationTargetException e) {
            JSONRPCResult errorResult = new JSONRPCResult(490, id, (Object)e.getCause());
            return errorResult.toString().getBytes("UTF-8");
        }
        catch (RuntimeException e) {
            JSONRPCResult errorResult = new JSONRPCResult(490, id, (Object)e.getCause());
            return errorResult.toString().getBytes("UTF-8");
        }
    }

    private Operation findOperation(String method) {
        if (method.contains(".")) {
            method = method.substring(method.lastIndexOf(".") + 1);
        }
        List<Operation> operations = this.serviceContract.getInterface().getOperations();
        Operation result = null;
        for (Operation o : operations) {
            if (!o.getName().equalsIgnoreCase(method)) continue;
            result = o;
            break;
        }
        return result;
    }
}

