/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jsonrpc.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.binding.jsonrpc.JSONRPCBinding;
import org.apache.tuscany.sca.binding.jsonrpc.provider.JSONRPCServiceServlet;
import org.apache.tuscany.sca.binding.jsonrpc.provider.ScaDomainScriptServlet;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONRPCServiceBindingProvider
implements ServiceBindingProvider {
    private static final String SCA_DOMAIN_SCRIPT = "/SCADomain/scaDomain.js";
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private JSONRPCBinding binding;
    private ServletHost servletHost;
    private List<String> servletMappings = new ArrayList<String>();
    private String domainScriptMapping;

    public JSONRPCServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, JSONRPCBinding binding, ServletHost servletHost) {
        this.component = component;
        this.service = service;
        this.binding = binding;
        this.servletHost = servletHost;
        try {
            this.serviceContract = (InterfaceContract)service.getInterfaceContract().clone();
        }
        catch (CloneNotSupportedException e) {
            this.serviceContract = service.getInterfaceContract();
        }
        this.setDataBinding(this.serviceContract.getInterface());
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return false;
    }

    @Override
    public void start() {
        this.serviceContract.getInterface().resetDataBinding("JSON");
        Class<?> serviceInterface = this.getTargetJavaClass(this.serviceContract.getInterface());
        Object proxy = this.component.getComponentContext().createSelfReference(serviceInterface, this.service).getService();
        JSONRPCServiceServlet serviceServlet = new JSONRPCServiceServlet(this.binding, this.service, this.serviceContract, serviceInterface, proxy);
        String mapping = this.binding.getURI();
        if (!mapping.endsWith("/")) {
            mapping = mapping + "/";
        }
        if (!mapping.endsWith("*")) {
            mapping = mapping + "*";
        }
        this.servletHost.addServletMapping(mapping, (Servlet)serviceServlet);
        this.servletMappings.add(mapping);
        this.servletHost.addServletMapping(this.binding.getURI(), (Servlet)serviceServlet);
        this.servletMappings.add(this.binding.getURI());
        URI uri = URI.create(this.servletHost.getURLMapping(this.binding.getURI()).toString());
        int port = uri.getPort();
        if (port == -1) {
            port = this.servletHost.getDefaultPort();
        }
        this.domainScriptMapping = URI.create("http://localhost:" + port + SCA_DOMAIN_SCRIPT).toString();
        ScaDomainScriptServlet scaDomainServlet = (ScaDomainScriptServlet)this.servletHost.getServletMapping(this.domainScriptMapping);
        if (scaDomainServlet == null) {
            scaDomainServlet = new ScaDomainScriptServlet();
            this.servletHost.addServletMapping(this.domainScriptMapping, (Servlet)scaDomainServlet);
        }
        scaDomainServlet.addService(this.binding.getName());
    }

    @Override
    public void stop() {
        for (String mapping : this.servletMappings) {
            this.servletHost.removeServletMapping(mapping);
        }
        ScaDomainScriptServlet scaDomainServlet = (ScaDomainScriptServlet)this.servletHost.getServletMapping(this.domainScriptMapping);
        if (scaDomainServlet != null) {
            scaDomainServlet.removeService(this.binding.getName());
            if (scaDomainServlet.getServiceNames().isEmpty()) {
                this.servletHost.removeServletMapping(this.domainScriptMapping);
            }
        }
    }

    private Class<?> getTargetJavaClass(Interface targetInterface) {
        return ((JavaInterface)targetInterface).getJavaClass();
    }

    private void setDataBinding(Interface interfaze) {
        List<Operation> operations = interfaze.getOperations();
        for (Operation operation : operations) {
            DataType outputType;
            operation.setDataBinding("JSON");
            DataType<List<DataType>> inputType = operation.getInputType();
            if (inputType != null) {
                List<DataType> logical = inputType.getLogical();
                for (DataType inArg : logical) {
                    if ("java:simpleType".equals(inArg.getDataBinding())) continue;
                    inArg.setDataBinding("JSON");
                }
            }
            if ((outputType = operation.getOutputType()) == null || "java:simpleType".equals(outputType.getDataBinding())) continue;
            outputType.setDataBinding("JSON");
        }
    }
}

