/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.WireFormatJMSTextXML;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class WireFormatJMSTextXMLServiceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;

    public WireFormatJMSTextXMLServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
    }

    public Message invoke(Message msg) {
        if (this.jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeRequest(msg);
        }
        msg = this.getNext().invoke(msg);
        if (this.jmsBinding.getResponseWireFormat() instanceof WireFormatJMSTextXML) {
            msg = this.invokeResponse(msg);
        }
        return msg;
    }

    public Message invokeRequest(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        javax.jms.Message jmsMsg = context.getJmsMsg();
        if ("onMessage".equals(msg.getOperation().getName())) {
            msg.setBody(new Object[]{jmsMsg});
        } else {
            Object requestPayload = this.requestMessageProcessor.extractPayloadFromJMSMessage(jmsMsg);
            msg.setBody(requestPayload);
        }
        return msg;
    }

    public Message invokeResponse(Message msg) {
        JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
        Session session = context.getJmsSession();
        javax.jms.Message responseJMSMsg = msg.isFault() ? this.responseMessageProcessor.createFaultMessage(session, (Throwable)msg.getBody()) : this.responseMessageProcessor.insertPayloadIntoJMSMessage(session, msg.getBody());
        msg.setBody(responseJMSMsg);
        return msg;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

