/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime;

import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.runtime.WireFormatJMSTextXMLReferenceInterceptor;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.WebServiceBindingFactory;
import org.apache.tuscany.sca.binding.ws.wsdlgen.BindingWSDLGenerator;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class WireFormatJMSTextXMLReferenceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry registry;
    private RuntimeComponent component;
    private RuntimeComponentReference reference;
    private JMSBinding binding;
    private InterfaceContract interfaceContract;

    public WireFormatJMSTextXMLReferenceProvider(ExtensionPointRegistry registry, RuntimeComponent component, RuntimeComponentReference reference, Binding binding) {
        this.registry = registry;
        this.component = component;
        this.reference = reference;
        this.binding = (JMSBinding)binding;
        if (this.binding.getRequestMessageProcessorName().equals("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor")) {
            this.binding.setRequestMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
            this.binding.setResponseMessageProcessorName("org.apache.tuscany.sca.binding.jms.provider.XMLTextMessageProcessor");
        }
        if (reference.getInterfaceContract() != null && !this.isOnMessage()) {
            WebServiceBindingFactory wsFactory = registry.getExtensionPoint(WebServiceBindingFactory.class);
            WebServiceBinding wsBinding = wsFactory.createWebServiceBinding();
            BindingWSDLGenerator.generateWSDL(component, reference, wsBinding, registry, null);
            this.interfaceContract = wsBinding.getBindingInterfaceContract();
            this.interfaceContract.getInterface().resetDataBinding(OMElement.class.getName());
        } else {
            this.interfaceContract = reference.getInterfaceContract();
        }
    }

    protected boolean isOnMessage() {
        InterfaceContract ic = this.reference.getInterfaceContract();
        if (ic.getInterface().getOperations().size() != 1) {
            return false;
        }
        return "onMessage".equals(ic.getInterface().getOperations().get(0).getName());
    }

    public InterfaceContract getWireFormatInterfaceContract() {
        return this.interfaceContract;
    }

    public Interceptor createInterceptor() {
        return new WireFormatJMSTextXMLReferenceInterceptor(this.binding, null, this.reference.getRuntimeWire(this.binding));
    }

    public String getPhase() {
        return "reference.binding.wireformat";
    }
}

