/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.StringReader;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;

public class XMLTextMessageProcessor
extends AbstractMessageProcessor {
    public XMLTextMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object[] extractPayload(Message msg) {
        try {
            Object[] os;
            String xml = ((TextMessage)msg).getText();
            if (xml != null) {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xml));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                os = new Object[]{builder.getDocumentElement()};
            } else {
                os = new Object[]{};
            }
            return os;
        }
        catch (XMLStreamException e) {
            throw new JMSBindingException(e);
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected Message createJMSMessage(Session session, Object o) {
        try {
            TextMessage message = session.createTextMessage();
            if (o instanceof OMElement) {
                message.setText(o.toString());
            } else if (o instanceof Object[] && ((Object[])o)[0] instanceof OMElement) {
                message.setText(((Object[])o)[0].toString());
            } else if (o != null) {
                throw new IllegalStateException("expecting OMElement payload: " + o);
            }
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

