/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.AbstractMessageProcessor;

public class TextMessageProcessor
extends AbstractMessageProcessor {
    public TextMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    protected Object[] extractPayload(Message msg) {
        try {
            if (!(msg instanceof TextMessage)) {
                throw new IllegalStateException("expecting JMS TextMessage: " + msg);
            }
            return new Object[]{((TextMessage)msg).getText()};
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected Message createJMSMessage(Session session, Object o) {
        try {
            TextMessage message = session.createTextMessage();
            message.setText(String.valueOf(o));
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }
}

