/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.RRBJMSBindingListener;
import org.apache.tuscany.sca.binding.jms.transport.TransportServiceInterceptor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ServiceBindingProviderRRB;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;
import org.apache.tuscany.sca.work.WorkScheduler;

public class JMSBindingServiceBindingProvider
implements ServiceBindingProviderRRB {
    private static final Logger logger = Logger.getLogger(JMSBindingServiceBindingProvider.class.getName());
    private RuntimeComponentService service;
    private Binding targetBinding;
    private JMSBinding jmsBinding;
    private JMSResourceFactory jmsResourceFactory;
    private MessageConsumer consumer;
    private WorkScheduler workScheduler;
    private boolean running;
    private Destination destination;
    private ExtensionPointRegistry extensionPoints;
    private RuntimeComponent component;
    private InterfaceContract wsdlInterfaceContract;
    private ProviderFactoryExtensionPoint providerFactories;
    private ModelFactoryExtensionPoint modelFactories;
    private MessageFactory messageFactory;
    private OperationSelectorProviderFactory operationSelectorProviderFactory;
    private OperationSelectorProvider operationSelectorProvider;
    private WireFormatProviderFactory requestWireFormatProviderFactory;
    private WireFormatProvider requestWireFormatProvider;
    private WireFormatProviderFactory responseWireFormatProviderFactory;
    private WireFormatProvider responseWireFormatProvider;

    public JMSBindingServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, Binding targetBinding, JMSBinding binding, WorkScheduler workScheduler, ExtensionPointRegistry extensionPoints, JMSResourceFactory jmsResourceFactory) {
        this.component = component;
        this.service = service;
        this.jmsBinding = binding;
        this.workScheduler = workScheduler;
        this.targetBinding = targetBinding;
        this.extensionPoints = extensionPoints;
        this.jmsResourceFactory = jmsResourceFactory;
        if (this.jmsBinding.getDestinationName().equals("NODESTINATION") && !service.isCallback()) {
            this.jmsBinding.setDestinationName(service.getName());
        }
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = this.modelFactories.getFactory(MessageFactory.class);
        this.providerFactories = extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.operationSelectorProviderFactory = (OperationSelectorProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getOperationSelector().getClass());
        if (this.operationSelectorProviderFactory != null) {
            this.operationSelectorProvider = this.operationSelectorProviderFactory.createServiceOperationSelectorProvider(component, service, this.jmsBinding);
        }
        this.requestWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getRequestWireFormat().getClass());
        if (this.requestWireFormatProviderFactory != null) {
            this.requestWireFormatProvider = this.requestWireFormatProviderFactory.createServiceWireFormatProvider(component, service, this.jmsBinding);
        }
        this.responseWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getResponseWireFormat().getClass());
        if (this.responseWireFormatProviderFactory != null) {
            this.responseWireFormatProvider = this.responseWireFormatProviderFactory.createServiceWireFormatProvider(component, service, this.jmsBinding);
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.requestWireFormatProvider.getWireFormatInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public void start() {
        this.running = true;
        try {
            this.registerListerner();
        }
        catch (Exception e) {
            throw new JMSBindingException("Error starting JMSServiceBinding", e);
        }
    }

    public void stop() {
        block2: {
            this.running = false;
            try {
                this.consumer.close();
                this.jmsResourceFactory.closeConnection();
            }
            catch (Exception e) {
                if ("Transport disposed.".equals(e.getMessage())) break block2;
                throw new JMSBindingException("Error stopping JMSServiceBinding", e);
            }
        }
    }

    private void registerListerner() throws NamingException, JMSException {
        Session session = this.jmsResourceFactory.createSession();
        this.destination = this.lookupDestinationQueue();
        if (this.destination == null) {
            this.destination = session.createTemporaryQueue();
        }
        this.consumer = this.jmsBinding.getJMSSelector() != null ? session.createConsumer(this.destination, this.jmsBinding.getJMSSelector()) : session.createConsumer(this.destination);
        RRBJMSBindingListener tmpListener = null;
        final RRBJMSBindingListener listener = tmpListener = new RRBJMSBindingListener(this.jmsBinding, this.jmsResourceFactory, this.service, this.targetBinding, this.messageFactory);
        try {
            this.consumer.setMessageListener((MessageListener)listener);
            this.jmsResourceFactory.startConnection();
        }
        catch (IllegalStateException e) {
            this.jmsResourceFactory.startConnection();
            this.workScheduler.scheduleWork(new Runnable(){

                public void run() {
                    try {
                        while (JMSBindingServiceBindingProvider.this.running) {
                            final Message msg = JMSBindingServiceBindingProvider.this.consumer.receive();
                            JMSBindingServiceBindingProvider.this.workScheduler.scheduleWork(new Runnable(){

                                public void run() {
                                    try {
                                        listener.onMessage(msg);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        logger.log(Level.INFO, "JMS " + (this.service.isCallback() ? "callback service" : "service") + " '" + this.service.getName() + "' listening on destination " + (this.destination instanceof Queue ? ((Queue)this.destination).getQueueName() : ((Topic)this.destination).getTopicName()));
    }

    private Destination lookupDestinationQueue() throws NamingException, JMSBindingException {
        if (this.service.isCallback() && "NODESTINATION".equals(this.jmsBinding.getDestinationName())) {
            return null;
        }
        Destination destination = this.jmsResourceFactory.lookupDestination(this.jmsBinding.getDestinationName());
        String qCreateMode = this.jmsBinding.getDestinationCreate();
        if (qCreateMode.equals("always")) {
            if (destination != null) {
                throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " already exists but has create mode of \"" + qCreateMode + "\" while registering service " + this.service.getName() + " listener");
            }
            destination = this.jmsResourceFactory.createDestination(this.jmsBinding.getDestinationName());
        } else if (qCreateMode.equals("ifnotexist")) {
            if (destination == null) {
                destination = this.jmsResourceFactory.createDestination(this.jmsBinding.getDestinationName());
            }
        } else if (qCreateMode.equals("never") && destination == null) {
            throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " not found but create mode of \"" + qCreateMode + "\" while registering service " + this.service.getName() + " listener");
        }
        if (destination == null) {
            throw new JMSBindingException("JMS Destination " + this.jmsBinding.getDestinationName() + " not found with create mode of \"" + qCreateMode + "\" while registering service " + this.service.getName() + " listener");
        }
        return destination;
    }

    public String getDestinationName() {
        try {
            if (this.destination instanceof Queue) {
                return ((Queue)this.destination).getQueueName();
            }
            if (this.destination instanceof Topic) {
                return ((Topic)this.destination).getTopicName();
            }
            return null;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public void configureBindingChain(RuntimeWire runtimeWire) {
        InvocationChain bindingChain = runtimeWire.getBindingInvocationChain();
        bindingChain.addInterceptor("service.binding.transport", (Interceptor)new TransportServiceInterceptor(this.jmsBinding, this.jmsResourceFactory, runtimeWire));
        bindingChain.addInterceptor(this.operationSelectorProvider.getPhase(), this.operationSelectorProvider.createInterceptor());
        bindingChain.addInterceptor(this.requestWireFormatProvider.getPhase(), this.requestWireFormatProvider.createInterceptor());
        if (!this.jmsBinding.getRequestWireFormat().equals(this.jmsBinding.getResponseWireFormat())) {
            bindingChain.addInterceptor(this.responseWireFormatProvider.getPhase(), this.responseWireFormatProvider.createInterceptor());
        }
    }
}

