/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.provider.DefaultJMSResourceFactoryExtensionPoint;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingReferenceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.work.WorkScheduler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBindingProviderFactory
implements BindingProviderFactory<JMSBinding> {
    private WorkScheduler workScheduler;
    private ExtensionPointRegistry extensionPoints;
    private JMSResourceFactoryExtensionPoint jmsRFEP;

    public JMSBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.workScheduler = utilities.getUtility(WorkScheduler.class);
        this.jmsRFEP = extensionPoints.getExtensionPoint(JMSResourceFactoryExtensionPoint.class);
        if (this.jmsRFEP == null) {
            this.jmsRFEP = new DefaultJMSResourceFactoryExtensionPoint();
            extensionPoints.addExtensionPoint(this.jmsRFEP);
        }
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, JMSBinding binding) {
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory(binding);
        return new JMSBindingReferenceBindingProvider(component, reference, binding, this.extensionPoints, jmsRF);
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, JMSBinding binding) {
        JMSResourceFactory jmsRF = this.jmsRFEP.createJMSResourceFactory(binding);
        return new JMSBindingServiceBindingProvider(component, service, binding, binding, this.workScheduler, this.extensionPoints, jmsRF);
    }

    @Override
    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }
}

