/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.osoa.sca.ServiceRuntimeException;

public abstract class AbstractMessageProcessor
implements JMSMessageProcessor {
    protected String operationPropertyName;
    protected boolean xmlFormat = true;

    public AbstractMessageProcessor(JMSBinding jmsBinding) {
        this.operationPropertyName = jmsBinding.getOperationSelectorPropertyName();
    }

    public String getOperationName(Message message) {
        try {
            return message.getStringProperty(this.operationPropertyName);
        }
        catch (JMSException e) {
            throw new JMSBindingException("Exception retreiving operation name from message", e);
        }
    }

    public void setOperationName(String operationName, Message message) {
        try {
            message.setStringProperty(this.operationPropertyName, operationName);
        }
        catch (JMSException e) {
            throw new JMSBindingException("Exception setting the operation name on message", e);
        }
    }

    public Message insertPayloadIntoJMSMessage(Session session, Object o) {
        return this.createJMSMessage(session, o);
    }

    public Object extractPayloadFromJMSMessage(Message msg) {
        try {
            if (msg.getBooleanProperty("org_apache_tuscany_sca_fault")) {
                throw new ServiceRuntimeException("remote service exception, see nested exception", (Throwable)((ObjectMessage)msg).getObject());
            }
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
        return this.extractPayload(msg);
    }

    public Message createFaultMessage(Session session, Throwable o) {
        try {
            ObjectMessage message = session.createObjectMessage();
            if (o instanceof ServiceRuntimeException && ((ServiceRuntimeException)o).getCause() instanceof InvocationTargetException) {
                message.setObject((Serializable)o.getCause());
            } else {
                message.setObject((Serializable)o);
            }
            message.setBooleanProperty("org_apache_tuscany_sca_fault", true);
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected abstract Object[] extractPayload(Message var1);

    protected abstract Message createJMSMessage(Session var1, Object var2);
}

