/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.policy.authentication.token;

import javax.jms.JMSException;
import javax.security.auth.Subject;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.policy.authentication.token.JMSTokenAuthenticationPolicy;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.SecurityUtil;
import org.apache.tuscany.sca.policy.authentication.token.TokenPrincipal;

public class JMSTokenAuthenticationServicePolicyInterceptor
implements Interceptor {
    private Invoker next;
    private PolicySet policySet = null;
    private String context;
    private JMSTokenAuthenticationPolicy policy;

    public JMSTokenAuthenticationServicePolicyInterceptor(String context, PolicySet policySet) {
        this.policySet = policySet;
        this.context = context;
        this.init();
    }

    private void init() {
        if (this.policySet != null) {
            for (Object policyObject : this.policySet.getPolicies()) {
                if (!(policyObject instanceof JMSTokenAuthenticationPolicy)) continue;
                this.policy = (JMSTokenAuthenticationPolicy)policyObject;
                break;
            }
        }
    }

    public Message invoke(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message jmsMsg = context.getJmsMsg();
            String token = jmsMsg.getStringProperty(this.policy.getTokenName().toString());
            Subject subject = SecurityUtil.getSubject(msg);
            TokenPrincipal principal = SecurityUtil.getPrincipal(subject, TokenPrincipal.class);
            if (principal == null) {
                principal = new TokenPrincipal(token);
                subject.getPrincipals().add(principal);
            }
            System.out.println("JMS service received token: " + principal.getName());
            return this.getNext().invoke(msg);
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

