/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.operationselector.jmsdefault.runtime;

import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.core.assembly.EndpointReferenceImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class OperationSelectorJMSDefaultServiceInterceptor
implements Interceptor {
    private static final String ON_MESSAGE_METHOD_NAME = "onMessage";
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private RuntimeComponentService service;
    private List<Operation> serviceOperations;

    public OperationSelectorJMSDefaultServiceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.service = (RuntimeComponentService)runtimeWire.getTarget().getContract();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message msg) {
        try {
            JMSBindingContext context = (JMSBindingContext)msg.getBindingContext();
            javax.jms.Message jmsMsg = context.getJmsMsg();
            String operationName = this.requestMessageProcessor.getOperationName(jmsMsg);
            Operation operation = this.getTargetOperation(operationName);
            msg.setOperation(operation);
            ReferenceParameters parameters = msg.getFrom().getReferenceParameters();
            if (this.service.getInterfaceContract().getCallbackInterface() != null) {
                String callbackID;
                Destination replyTo;
                String callbackdestName = jmsMsg.getStringProperty("scaCallbackQueue ");
                if (callbackdestName == null && msg.getOperation().isNonBlocking() && (replyTo = jmsMsg.getJMSReplyTo()) != null) {
                    String string = callbackdestName = replyTo instanceof Queue ? ((Queue)replyTo).getQueueName() : ((Topic)replyTo).getTopicName();
                }
                if (callbackdestName != null) {
                    parameters.setCallbackReference(new EndpointReferenceImpl("jms:" + callbackdestName));
                }
                if ((callbackID = jmsMsg.getStringProperty("CallbackID")) != null) {
                    parameters.setCallbackID(callbackID);
                }
            }
            return msg;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected Operation getTargetOperation(String operationName) {
        Operation operation = null;
        if (this.serviceOperations.size() == 1) {
            operation = this.serviceOperations.get(0);
        } else if (operationName != null) {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(operationName)) continue;
                operation = op;
                break;
            }
        } else {
            for (Operation op : this.serviceOperations) {
                if (!op.getName().equals(ON_MESSAGE_METHOD_NAME)) continue;
                operation = op;
                break;
            }
        }
        if (operation == null) {
            throw new JMSBindingException("Can't find operation " + (operationName != null ? operationName : ON_MESSAGE_METHOD_NAME));
        }
        return operation;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

