/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.impl;

import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingConstants;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.operationselector.jmsdefault.OperationSelectorJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstext.WireFormatJMSText;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.WireFormatJMSTextXML;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBindingProcessor
implements StAXArtifactProcessor<JMSBinding> {
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    private Monitor monitor;

    public JMSBindingProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-jms-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-jms-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return JMSBindingConstants.BINDING_JMS_QNAME;
    }

    @Override
    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }

    @Override
    public JMSBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String responseConnectionName;
        String requestConnectionName;
        String messageProcessorName;
        String jndiURL;
        String initialContextFactory;
        String correlationScheme;
        String uri;
        JMSBinding jmsBinding = new JMSBinding();
        this.policyProcessor.readPolicies(jmsBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            jmsBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null && uri.length() > 0) {
            this.parseURI(uri, jmsBinding);
        }
        if ((correlationScheme = reader.getAttributeValue(null, "correlationScheme")) != null && correlationScheme.length() > 0) {
            if (JMSBindingConstants.VALID_CORRELATION_SCHEMES.contains(correlationScheme.toLowerCase())) {
                jmsBinding.setCorrelationScheme(correlationScheme);
            } else {
                this.error("InvalidCorrelationScheme", reader, correlationScheme);
            }
        }
        if ((initialContextFactory = reader.getAttributeValue(null, "initialContextFactory")) != null && initialContextFactory.length() > 0) {
            jmsBinding.setInitialContextFactoryName(initialContextFactory);
        }
        if ((jndiURL = reader.getAttributeValue(null, "jndiURL")) != null && jndiURL.length() > 0) {
            jmsBinding.setJndiURL(jndiURL);
        }
        if ((messageProcessorName = reader.getAttributeValue(null, "messageProcessor")) != null && messageProcessorName.length() > 0) {
            if ("XMLTextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSTextXML());
                jmsBinding.setResponseWireFormat(new WireFormatJMSTextXML());
            } else if ("TextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSText());
                jmsBinding.setResponseWireFormat(new WireFormatJMSText());
            } else if ("ObjectMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSObject());
                jmsBinding.setResponseWireFormat(new WireFormatJMSObject());
            } else {
                jmsBinding.setRequestMessageProcessorName(messageProcessorName);
                jmsBinding.setResponseMessageProcessorName(messageProcessorName);
            }
        }
        if ((requestConnectionName = reader.getAttributeValue(null, "requestConnection")) != null && requestConnectionName.length() > 0) {
            jmsBinding.setRequestConnectionName(requestConnectionName);
        }
        if ((responseConnectionName = reader.getAttributeValue(null, "responseConnection")) != null && responseConnectionName.length() > 0) {
            jmsBinding.setResponseConnectionName(responseConnectionName);
        }
        boolean endFound = false;
        while (!endFound) {
            int fg = reader.next();
            switch (fg) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseDestination(reader, jmsBinding);
                    } else if ("connectionFactory".equals(elementName)) {
                        this.parseConnectionFactory(reader, jmsBinding);
                    } else if ("activationSpec".equals(elementName)) {
                        this.parseActivationSpec(reader, jmsBinding);
                    } else if ("response".equals(elementName)) {
                        this.parseResponse(reader, jmsBinding);
                    } else if ("resourceAdapter".equals(elementName)) {
                        this.parseResourceAdapter(reader, jmsBinding);
                    } else if ("headers".equals(elementName)) {
                        this.parseHeaders(reader, jmsBinding);
                    } else if ("operationProperties".equals(elementName)) {
                        this.parseOperationProperties(reader, jmsBinding);
                    } else if ("SubscriptionHeaders".equals(elementName)) {
                        this.parseSubscriptionHeaders(reader, jmsBinding);
                    } else {
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension != null) {
                            if (extension instanceof WireFormat) {
                                jmsBinding.setRequestWireFormat((WireFormat)extension);
                            } else if (extension instanceof OperationSelector) {
                                jmsBinding.setOperationSelector((OperationSelector)extension);
                            } else {
                                this.error("UnexpectedElement", reader, extension.toString());
                            }
                        }
                    }
                    reader.next();
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.equals(JMSBindingConstants.BINDING_JMS_QNAME)) {
                        endFound = true;
                        break;
                    }
                    this.error("UnexpectedElement", reader, x.toString());
                }
            }
        }
        if (jmsBinding.getOperationSelector() == null) {
            jmsBinding.setOperationSelector(new OperationSelectorJMSDefault());
        }
        if (jmsBinding.getRequestWireFormat() == null) {
            jmsBinding.setRequestWireFormat(new WireFormatJMSTextXML());
        }
        if (jmsBinding.getResponseWireFormat() == null) {
            jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
        }
        this.validate();
        return jmsBinding;
    }

    protected void parseURI(String uri, JMSBinding jmsBinding) {
        if (!uri.startsWith("jms:")) {
            this.error("MustStartWithSchema", jmsBinding, uri);
            return;
        }
        int i = uri.indexOf(63);
        if (i >= 0) {
            StringTokenizer st = new StringTokenizer(uri.substring(i + 1), "&");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("connectionFactoryName=")) {
                    jmsBinding.setConnectionFactoryName(s.substring(22));
                    continue;
                }
                this.error("UnknownTokenInURI", jmsBinding, s, uri);
                return;
            }
            jmsBinding.setDestinationName(uri.substring(4, i));
        } else {
            jmsBinding.setDestinationName(uri.substring(4));
        }
    }

    @Override
    public void resolve(JMSBinding model, ModelResolver resolver) throws ContributionResolveException {
        if (model.getRequestConnectionName() != null) {
            model.setRequestConnectionBinding(this.getConnectionBinding(model.getRequestConnectionName(), resolver));
        }
        if (model.getResponseConnectionName() != null) {
            model.setResponseConnectionBinding(this.getConnectionBinding(model.getResponseConnectionName(), resolver));
        }
    }

    private JMSBinding getConnectionBinding(String bindingName, ModelResolver resolver) {
        if (resolver instanceof ExtensibleModelResolver) {
            DefaultModelResolver dr = (DefaultModelResolver)((ExtensibleModelResolver)resolver).getDefaultModelResolver();
            Map models = dr.getModels();
            for (Object o : models.keySet()) {
                JMSBinding binding;
                if (!(o instanceof JMSBinding) || !bindingName.equals((binding = (JMSBinding)o).getName())) continue;
                return binding;
            }
        }
        return null;
    }

    @Override
    public void write(JMSBinding rmiBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "binding.jms");
        writer.writeEndElement();
    }

    private void parseDestination(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String create;
        String type;
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            this.warning("DoesntProcessDestinationType", jmsBinding, new Object[0]);
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("topic");
            } else {
                this.warning("InvalidDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            jmsBinding.setDestinationCreate(create);
        }
    }

    private void parseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding) {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setConnectionFactoryName(name);
        } else {
            this.error("MissingConnectionFactoryName", reader, new Object[0]);
        }
    }

    private void parseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding) {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            this.warning("DoesntProcessActivationSpec", jmsBinding, new Object[0]);
            jmsBinding.setActivationSpecName(name);
        } else {
            this.warning("MissingActivationSpecName", reader, new Object[0]);
        }
    }

    private void parseResponseDestination(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String create;
        String type;
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            this.warning("DoesntProcessResponseDestinationType", jmsBinding, new Object[0]);
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("topic");
            } else {
                this.warning("InvalidResponseDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            jmsBinding.setResponseDestinationCreate(create);
        }
    }

    private void parseResponseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding) {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            this.warning("DoesntProcessResponseConnectionFactory", jmsBinding, new Object[0]);
            jmsBinding.setResponseConnectionFactoryName(name);
        } else {
            this.warning("MissingResponseConnectionFactory", reader, new Object[0]);
        }
    }

    private void parseResponseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding) {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            this.warning("DoesntProcessResponseActivationSpec", jmsBinding, new Object[0]);
            jmsBinding.setResponseActivationSpecName(name);
        } else {
            this.warning("MissingResponseActivationSpec", reader, new Object[0]);
        }
    }

    private void parseResponse(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseResponseDestination(reader, jmsBinding);
                    } else if ("connectionFactory".equals(elementName)) {
                        this.parseResponseConnectionFactory(reader, jmsBinding);
                    } else if ("activationSpec".equals(elementName)) {
                        this.parseResponseActivationSpec(reader, jmsBinding);
                    }
                    reader.next();
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("response")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseResourceAdapter(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        this.warning("DoesntProcessResourceAdapter", jmsBinding, new Object[0]);
    }

    private void parseHeaders(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsCorrelationId;
        String jmsType = reader.getAttributeValue(null, "JMSType");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setJMSType(jmsType);
        }
        if ((jmsCorrelationId = reader.getAttributeValue(null, "JMSCorrelationID")) != null && jmsCorrelationId.length() > 0) {
            jmsBinding.setJMSCorrelationId(jmsCorrelationId);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "JMSDeliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(true);
            } else if ("NON_PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(false);
            } else {
                this.warning("InvalidJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "JMSTimeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setJMSTimeToLive(Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "JMSPriority")) != null && jmsPriority.length() > 0) {
            int p = Integer.parseInt(jmsPriority);
            if (p >= 0 && p <= 9) {
                jmsBinding.setJMSPriority(p);
            } else {
                this.warning("InvalidJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseProperty(reader, jmsBinding);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseProperty(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        String type = reader.getAttributeValue(null, "type");
        if (name != null && name.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setProperty(name, value);
        }
    }

    private void parseOperationProperties(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String opName = reader.getAttributeValue(null, "name");
        if (opName == null || opName.length() < 1) {
            this.warning("MissingJMSOperationPropertyName", jmsBinding, new Object[0]);
            return;
        }
        String nativeOpName = reader.getAttributeValue(null, "nativeOperation");
        if (nativeOpName != null && nativeOpName.length() > 0) {
            jmsBinding.setNativeOperationName(opName, nativeOpName);
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("headers")) break;
                    this.parseOperationHeaders(reader, jmsBinding, opName);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("operationProperties")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationHeaders(XMLStreamReader reader, JMSBinding jmsBinding, String opName) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsCorrelationId;
        String jmsType = reader.getAttributeValue(null, "JMSType");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setOperationJMSType(opName, jmsType);
        }
        if ((jmsCorrelationId = reader.getAttributeValue(null, "JMSCorrelationID")) != null && jmsCorrelationId.length() > 0) {
            jmsBinding.setOperationJMSCorrelationId(opName, jmsCorrelationId);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "JMSDeliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(true);
            } else if ("NON_PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setOperationJMSDeliveryMode(opName, false);
            } else {
                this.warning("InvalidOPJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "JMSTimeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setOperationJMSTimeToLive(opName, Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "JMSPriority")) != null && jmsPriority.length() > 0) {
            int p = Integer.parseInt(jmsPriority);
            if (p >= 0 && p <= 9) {
                jmsBinding.setOperationJMSPriority(opName, p);
            } else {
                this.warning("InvalidOPJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseOperationPropertyProperties(reader, jmsBinding, opName);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationPropertyProperties(XMLStreamReader reader, JMSBinding jmsBinding, String opName) throws XMLStreamException {
        String propName = reader.getAttributeValue(null, "name");
        String type = reader.getAttributeValue(null, "type");
        if (propName != null && propName.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setOperationProperty(opName, propName, value);
        }
    }

    private void parseSubscriptionHeaders(XMLStreamReader reader, JMSBinding jmsBinding) {
        String jmsSelector = reader.getAttributeValue(null, "JMSSelector");
        if (jmsSelector != null && jmsSelector.length() > 0) {
            jmsBinding.setJMSSelector(jmsSelector);
        }
    }

    public void validate() throws JMSBindingException {
    }
}

