/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.headers;

import java.util.Map;
import javax.jms.JMSException;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.jms.context.JMSBindingContext;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessor;
import org.apache.tuscany.sca.binding.jms.provider.JMSMessageProcessorUtil;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.ReferenceParameters;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class HeaderReferenceInterceptor
implements Interceptor {
    private Invoker next;
    private RuntimeWire runtimeWire;
    private JMSResourceFactory jmsResourceFactory;
    private JMSBinding jmsBinding;
    private JMSMessageProcessor requestMessageProcessor;
    private JMSMessageProcessor responseMessageProcessor;
    private String correlationScheme;
    private WireFormat requestWireFormat;
    private WireFormat responseWireFormat;

    public HeaderReferenceInterceptor(JMSBinding jmsBinding, JMSResourceFactory jmsResourceFactory, RuntimeWire runtimeWire) {
        this.jmsBinding = jmsBinding;
        this.runtimeWire = runtimeWire;
        this.jmsResourceFactory = jmsResourceFactory;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        this.correlationScheme = jmsBinding.getCorrelationScheme();
    }

    public Message invoke(Message msg) {
        return this.next.invoke(this.invokeRequest(msg));
    }

    public Message invokeRequest(Message tuscanyMsg) {
        try {
            ReferenceParameters parameters;
            Object conversationID;
            JMSBindingContext context = (JMSBindingContext)tuscanyMsg.getBindingContext();
            javax.jms.Message jmsMsg = (javax.jms.Message)tuscanyMsg.getBody();
            Operation operation = tuscanyMsg.getOperation();
            String operationName = operation.getName();
            RuntimeComponentReference reference = (RuntimeComponentReference)this.runtimeWire.getSource().getContract();
            this.requestMessageProcessor.setOperationName(this.jmsBinding.getNativeOperationName(operationName), jmsMsg);
            if (this.jmsBinding.getOperationJMSDeliveryMode(operationName) != null) {
                if (this.jmsBinding.getOperationJMSDeliveryMode(operationName).booleanValue()) {
                    jmsMsg.setJMSDeliveryMode(2);
                } else {
                    jmsMsg.setJMSDeliveryMode(1);
                }
            }
            if (this.jmsBinding.getOperationJMSCorrelationId(operationName) != null) {
                jmsMsg.setJMSCorrelationID(this.jmsBinding.getOperationJMSCorrelationId(operationName));
            }
            if (this.jmsBinding.getOperationJMSPriority(operationName) != null) {
                jmsMsg.setJMSPriority(this.jmsBinding.getOperationJMSPriority(operationName).intValue());
            }
            if (this.jmsBinding.getOperationJMSType(operationName) != null) {
                jmsMsg.setJMSType(this.jmsBinding.getOperationJMSType(operationName));
            }
            if ((conversationID = (parameters = tuscanyMsg.getFrom().getReferenceParameters()).getConversationID()) != null) {
                jmsMsg.setStringProperty("scaConversationId", conversationID.toString());
            }
            if (tuscanyMsg.getFrom().getCallbackEndpoint() != null) {
                String callbackDestName;
                if (parameters.getCallbackID() != null) {
                    jmsMsg.setStringProperty("CallbackID", parameters.getCallbackID().toString());
                }
                if ((callbackDestName = this.getCallbackDestinationName(reference)) != null) {
                    jmsMsg.setStringProperty("scaCallbackQueue ", callbackDestName);
                }
            }
            for (String propName : this.jmsBinding.getPropertyNames()) {
                Object value = this.jmsBinding.getProperty(propName);
                jmsMsg.setObjectProperty(propName, value);
            }
            Map<String, Object> operationProperties = this.jmsBinding.getOperationProperties(operationName);
            if (operationProperties != null) {
                for (String propName : operationProperties.keySet()) {
                    Object value = operationProperties.get(propName);
                    jmsMsg.setObjectProperty(propName, value);
                }
            }
            if (this.jmsBinding.getOperationJMSTimeToLive(operationName) != null) {
                context.setTimeToLive(this.jmsBinding.getOperationJMSTimeToLive(operationName) * 2L);
            } else {
                context.setTimeToLive(20000L);
            }
            return tuscanyMsg;
        }
        catch (JMSException e) {
            throw new JMSBindingException(e);
        }
    }

    protected String getCallbackDestinationName(RuntimeComponentReference reference) {
        RuntimeComponentService s = (RuntimeComponentService)reference.getCallbackService();
        JMSBinding b = s.getBinding(JMSBinding.class);
        if (b != null) {
            JMSBindingServiceBindingProvider bp = (JMSBindingServiceBindingProvider)s.getBindingProvider(b);
            return bp.getDestinationName();
        }
        return null;
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }
}

