/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class HTTPCacheContext {
    public static final SimpleDateFormat RFC822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    public boolean enabled;
    public String eTag;
    public String lastModified;
    public Date lastModifiedDate;
    public boolean ifModifiedSince;
    public boolean ifUnmodifiedSince;
    public boolean ifMatch;
    public boolean ifNoneMatch;
    public boolean ifRange;

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String tag) {
        this.eTag = tag;
        this.enabled = true;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public Date getLastModifiedAsDate() {
        return this.lastModifiedDate;
    }

    public void setLastModified(String lastModified) throws ParseException {
        this.lastModified = lastModified;
        this.lastModifiedDate = RFC822DateFormat.parse(lastModified);
        this.enabled = true;
    }

    public void setLastModified(Date updated) {
        this.lastModified = RFC822DateFormat.format(updated);
        this.lastModifiedDate = updated;
        this.enabled = true;
    }

    public boolean isIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public void setIfModifiedSince(boolean ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
        if (ifModifiedSince) {
            this.enabled = true;
        }
    }

    public boolean isIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public void setIfUnmodifiedSince(boolean ifUnmodifiedSince) {
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        if (ifUnmodifiedSince) {
            this.enabled = true;
        }
    }

    public boolean isIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(boolean ifMatch) {
        this.ifMatch = ifMatch;
        if (ifMatch) {
            this.enabled = true;
        }
    }

    public boolean isIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public void setIfNoneMatch(boolean ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
        if (ifNoneMatch) {
            this.enabled = true;
        }
    }

    public boolean isIfRange() {
        return this.ifRange;
    }

    public void setIfRange(boolean ifRange) {
        this.ifRange = ifRange;
        if (ifRange) {
            this.enabled = true;
        }
    }

    public String toString() {
        String PREDPREFIX = ", predicates=";
        StringBuffer sb = new StringBuffer(", predicates=");
        if (this.ifMatch || this.ifNoneMatch || this.ifModifiedSince || this.ifUnmodifiedSince || this.ifRange) {
            if (this.ifMatch) {
                if (sb.length() > ", predicates=".length()) {
                    sb.append(", ");
                }
                sb.append("If-Match");
            }
            if (this.ifNoneMatch) {
                if (sb.length() > ", predicates=".length()) {
                    sb.append(", ");
                }
                sb.append("If-None-Match");
            }
            if (this.ifModifiedSince) {
                if (sb.length() > ", predicates=".length()) {
                    sb.append(", ");
                }
                sb.append("If-Modified-Since");
            }
            if (this.ifUnmodifiedSince) {
                if (sb.length() > ", predicates=".length()) {
                    sb.append(", ");
                }
                sb.append("If-UnModified-Since");
            }
            if (this.ifRange) {
                if (sb.length() > ", predicates=".length()) {
                    sb.append(", ");
                }
                sb.append("If-Range");
            }
        } else {
            sb.append("null");
        }
        return "eTag=" + this.eTag + ", lastModified=" + this.lastModified + sb.toString();
    }

    public static HTTPCacheContext getCacheContextFromRequest(HttpServletRequest request) throws ParseException {
        String lastModifiedString;
        HTTPCacheContext context = new HTTPCacheContext();
        String eTag = request.getHeader("If-Match");
        if (eTag != null) {
            context.setETag(eTag);
            context.setIfMatch(true);
        }
        if ((eTag = request.getHeader("If-None-Match")) != null) {
            context.setETag(eTag);
            context.setIfNoneMatch(true);
        }
        if ((lastModifiedString = request.getHeader("If-Modified-Since")) != null) {
            context.setLastModified(lastModifiedString);
            context.setIfModifiedSince(true);
        }
        if ((lastModifiedString = request.getHeader("If-Unmodified-Since")) != null) {
            context.setLastModified(lastModifiedString);
            context.setIfUnmodifiedSince(true);
        }
        if ((lastModifiedString = request.getHeader("If-Range")) != null) {
            context.setLastModified(lastModifiedString);
            context.setIfRange(true);
        }
        return context;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

