/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.provider;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Link;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import java.util.Date;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GdataBindingUtil {
    GdataBindingUtil() {
    }

    static org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry(Entry feedEntry, DataType<?> itemClassType, DataType<?> itemXMLType, Mediator mediator) {
        if (feedEntry != null) {
            if (itemClassType.getPhysical() == Item.class) {
                String key = feedEntry.getId().toString();
                Item item = new Item();
                item.setTitle(feedEntry.getTitle().toString());
                TextContent content = (TextContent)feedEntry.getContent();
                item.setContents(content.getContent().getPlainText());
                for (Link link : feedEntry.getLinks()) {
                    if (link.getRel() == null || "self".equals(link.getRel())) {
                        if (item.getLink() != null) continue;
                        item.setLink(link.getHref().toString());
                        continue;
                    }
                    if ("related".equals(link.getRel())) {
                        item.setRelated(link.getHref().toString());
                        continue;
                    }
                    if (!"alternate".equals(link.getRel())) continue;
                    item.setAlternate(link.getHref().toString());
                }
                Date date = new Date(feedEntry.getUpdated().getValue());
                item.setDate(date);
                return new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(key, item);
            }
            String key = null;
            if (feedEntry.getId() != null) {
                key = feedEntry.getId();
            }
            if (feedEntry.getContent() == null) {
                return null;
            }
            TextContent content = (TextContent)feedEntry.getContent();
            String value = content.getContent().getPlainText();
            Object data = mediator.mediate(value, itemXMLType, itemClassType, null);
            return new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(key, data);
        }
        return null;
    }

    static Entry feedEntry(org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry, DataType<?> itemClassType, DataType<?> itemXMLType, Mediator mediator) {
        Object key = entry.getKey();
        Object data = entry.getData();
        if (data instanceof Item) {
            Date date;
            String alternate;
            String related;
            Item item = (Item)data;
            Entry feedEntry = new Entry();
            if (key != null) {
                feedEntry.setId(key.toString());
            }
            feedEntry.setTitle((TextConstruct)new PlainTextConstruct(item.getTitle()));
            feedEntry.setContent((TextConstruct)new PlainTextConstruct(item.getContents()));
            String href = item.getLink();
            if (href == null && key != null) {
                href = key.toString();
            }
            if (href != null) {
                feedEntry.addHtmlLink(href, "", "");
            }
            if ((related = item.getRelated()) != null) {
                feedEntry.addHtmlLink(related, "", "related");
            }
            if ((alternate = item.getAlternate()) != null) {
                feedEntry.addHtmlLink(alternate, "", "alternate");
            }
            if ((date = item.getDate()) != null) {
                DateTime datetime = new DateTime(date);
                feedEntry.setUpdated(datetime);
            }
            return feedEntry;
        }
        if (data != null) {
            Entry feedEntry = new Entry();
            feedEntry.setId(key.toString());
            feedEntry.setTitle((TextConstruct)new PlainTextConstruct("item"));
            String value = mediator.mediate(data, itemClassType, itemXMLType, null).toString();
            feedEntry.setContent((TextConstruct)new PlainTextConstruct(value));
            feedEntry.addHtmlLink(key.toString(), "", "");
            return feedEntry;
        }
        return null;
    }
}

