/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.gdata.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.gdata.GdataBinding;
import org.apache.tuscany.sca.binding.gdata.GdataBindingFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdataBindingProcessor
implements StAXArtifactProcessor<GdataBinding> {
    private QName BINDING_GDATA = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "binding.gdata");
    private final GdataBindingFactory factory;

    public GdataBindingProcessor(ModelFactoryExtensionPoint modelFactories) {
        this.factory = modelFactories.getFactory(GdataBindingFactory.class);
        System.out.println("[Debug Info]GdataBindingProcessor reached");
    }

    @Override
    public QName getArtifactType() {
        return this.BINDING_GDATA;
    }

    @Override
    public Class<GdataBinding> getModelType() {
        return GdataBinding.class;
    }

    @Override
    public GdataBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String password;
        String username;
        String serviceType;
        String uri;
        GdataBinding gdataBinding = this.factory.createGdataBinding();
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            gdataBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null) {
            gdataBinding.setURI(uri);
        }
        if ((serviceType = reader.getAttributeValue(null, "serviceType")) != null) {
            gdataBinding.setServiceType(serviceType);
        }
        if ((username = reader.getAttributeValue(null, "username")) != null) {
            gdataBinding.setUsername(username);
        }
        if ((password = reader.getAttributeValue(null, "password")) != null) {
            gdataBinding.setPassword(password);
        }
        return gdataBinding;
    }

    @Override
    public void write(GdataBinding gdataBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(this.BINDING_GDATA.getNamespaceURI(), this.BINDING_GDATA.getLocalPart());
        if (gdataBinding.getName() != null) {
            writer.writeAttribute("name", gdataBinding.getName());
        }
        if (gdataBinding.getURI() != null) {
            writer.writeAttribute("uri", gdataBinding.getURI());
        }
        if (gdataBinding.getServiceType() != null) {
            writer.writeAttribute("serviceType", gdataBinding.getServiceType());
        }
        if (gdataBinding.getUsername() != null) {
            writer.writeAttribute("username", gdataBinding.getUsername());
        }
        if (gdataBinding.getPassword() != null) {
            writer.writeAttribute("password", gdataBinding.getPassword());
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(GdataBinding gdataBinding, ModelResolver resolver) throws ContributionResolveException {
    }
}

