/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.tuscany.sca.binding.ejb.util.EJBLocator;

public class NamingEndpoint {
    private String jndiName;
    private EJBLocator locator;
    private boolean managed = true;

    public NamingEndpoint(String hostName, int port, String jndiName) {
        this.jndiName = jndiName;
        this.locator = new EJBLocator(hostName, port);
    }

    public NamingEndpoint(String name) {
        String managedEnv = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("managed");
            }
        });
        if (managedEnv != null) {
            this.managed = Boolean.valueOf(managedEnv);
        }
        if (!this.managed && name.startsWith("corbaname:iiop:")) {
            String[] parts = NamingEndpoint.split(name, '#');
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid corbaname: " + name);
            }
            this.jndiName = name;
            this.locator = new EJBLocator(parts[0], this.managed);
        } else {
            this.jndiName = name;
            this.locator = new EJBLocator(this.managed);
        }
    }

    private static String[] split(String str, char ch) {
        int index = str.lastIndexOf(ch);
        if (index == -1) {
            return new String[]{str, ""};
        }
        return new String[]{str.substring(0, index), str.substring(index + 1)};
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public EJBLocator getLocator() {
        return this.locator;
    }

    public String getCorbaname() {
        return this.locator.getCorbaname(this.jndiName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamingEndpoint) {
            NamingEndpoint endpoint = (NamingEndpoint)obj;
            return this.jndiName.equals(endpoint.jndiName);
        }
        return false;
    }

    public int hashCode() {
        return this.jndiName.hashCode();
    }

    public String toString() {
        return this.jndiName;
    }
}

