/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class MethodInfo
implements Serializable {
    private static final long serialVersionUID = -5557260979514687514L;
    private String name;
    private String returnType;
    private String[] parameterTypes;
    private String[] exceptionTypes;
    private String IDLName;
    private transient Method method;
    private static final Map signatures = new HashMap();

    MethodInfo(Method method) {
        int i;
        this.method = method;
        this.name = method.getName();
        this.returnType = method.getReturnType().getName();
        Class<?>[] types = method.getParameterTypes();
        this.parameterTypes = new String[types.length];
        for (i = 0; i < types.length; ++i) {
            this.parameterTypes[i] = types[i].getName();
        }
        types = method.getExceptionTypes();
        this.exceptionTypes = new String[types.length];
        for (i = 0; i < types.length; ++i) {
            this.exceptionTypes[i] = types[i].getName();
        }
        this.IDLName = this.name;
    }

    MethodInfo(String name, String returnType, String[] parameterTypes, String[] exceptionTypes) {
        this.name = name;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.exceptionTypes = exceptionTypes;
        this.IDLName = name;
    }

    private static String getName(String signature) {
        Class primitiveClass;
        String name = signature;
        int index = name.lastIndexOf(91);
        if (index != -1) {
            name = name.substring(index + 1);
        }
        if (name.charAt(0) == 'L' && name.charAt(name.length() - 1) == ';') {
            name = name.substring(1, name.length() - 1);
        }
        if ((primitiveClass = (Class)signatures.get(name)) != null) {
            name = primitiveClass.getName();
        }
        for (int i = 0; i < index + 1; ++i) {
            name = name + "[]";
        }
        return name;
    }

    String getName() {
        return this.name;
    }

    String[] getParameterTypes() {
        return this.parameterTypes;
    }

    String getReturnType() {
        return this.returnType;
    }

    String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(MethodInfo.getName(this.returnType)).append(" ").append(this.name).append("(");
        for (int j = 0; j < this.parameterTypes.length; ++j) {
            sb.append(MethodInfo.getName(this.parameterTypes[j])).append(" ").append("arg" + j);
            if (j >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (this.exceptionTypes.length > 0) {
            sb.append(" throws ");
            for (int k = 0; k < this.exceptionTypes.length; ++k) {
                sb.append(this.exceptionTypes[k]);
                if (k >= this.exceptionTypes.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(";");
        return sb.toString();
    }

    String getIDLName() {
        return this.IDLName;
    }

    void setIDLName(String name) {
        this.IDLName = name;
    }

    Method getMethod() {
        return this.method;
    }

    static {
        signatures.put("Z", Boolean.TYPE);
        signatures.put("B", Byte.TYPE);
        signatures.put("C", Character.TYPE);
        signatures.put("S", Short.TYPE);
        signatures.put("I", Integer.TYPE);
        signatures.put("J", Long.TYPE);
        signatures.put("F", Float.TYPE);
        signatures.put("D", Double.TYPE);
        signatures.put("V", Void.TYPE);
    }
}

