/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.provider;

import org.apache.tuscany.sca.binding.ejb.EJBBinding;
import org.apache.tuscany.sca.binding.ejb.util.EJBHandler;
import org.apache.tuscany.sca.binding.ejb.util.NamingEndpoint;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;

public class EJBBindingInvoker
implements Invoker,
DataExchangeSemantics {
    private Operation operation;
    private String location;
    private Class serviceInterface;

    public EJBBindingInvoker(EJBBinding ejbBinding, Class serviceInterface, Operation operation) {
        this.serviceInterface = serviceInterface;
        this.location = ejbBinding.getURI();
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(Message msg) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceInterface.getClassLoader());
            Object resp = this.doInvoke(msg.getBody());
            msg.setBody(resp);
        }
        catch (Throwable e) {
            e.printStackTrace();
            msg.setFaultBody(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return msg;
    }

    public Object doInvoke(Object payload) {
        NamingEndpoint endpoint = this.getNamingEndpoint();
        EJBHandler ejbHandler = new EJBHandler(endpoint, this.serviceInterface);
        String methodName = this.operation.getName();
        Object response = ejbHandler.invoke(methodName, (Object[])payload);
        return response;
    }

    protected NamingEndpoint getNamingEndpoint() {
        return new NamingEndpoint(this.location);
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

