/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.ejb.EJBBinding;
import org.apache.tuscany.sca.binding.ejb.impl.EJBBindingImpl;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBBindingProcessor
implements StAXArtifactProcessor<EJBBindingImpl> {
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private Monitor monitor;

    public EJBBindingProcessor(ModelFactoryExtensionPoint modelFactories, Monitor monitor) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.monitor = monitor;
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "binding-ejb-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public QName getArtifactType() {
        return EJBBinding.BINDING_EJB_QNAME;
    }

    @Override
    public EJBBindingImpl read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String requires;
        String ejbVersion;
        String sessionType;
        String ejbLinkName;
        String homeInterface;
        String uri;
        EJBBindingImpl ejbBinding = new EJBBindingImpl();
        this.policyProcessor.readPolicies(ejbBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            ejbBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null) {
            ejbBinding.setURI(uri);
        }
        if ((homeInterface = reader.getAttributeValue(null, "homeInterface")) != null) {
            ejbBinding.setHomeInterface(homeInterface);
        }
        if ((ejbLinkName = reader.getAttributeValue(null, "ejb-link-name")) != null) {
            ejbBinding.setEjbLinkName(ejbLinkName);
        }
        if ((sessionType = reader.getAttributeValue(null, "session-type")) != null) {
            if (sessionType.equals("stateless")) {
                ejbBinding.setSessionType(EJBBinding.SessionType.STATELESS);
            } else if (sessionType.equals("stateful")) {
                ejbBinding.setSessionType(EJBBinding.SessionType.STATEFUL);
            } else {
                this.error("UnknownEJBSessionType", reader, sessionType, name);
            }
        }
        if ((ejbVersion = reader.getAttributeValue(null, "ejb-version")) != null) {
            if (ejbVersion.equals("EJB2")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB2);
            } else if (ejbVersion.equals("EJB3")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB3);
            } else {
                this.error("UnknownEJBVersion", reader, ejbVersion, name);
            }
        }
        if ((requires = reader.getAttributeValue(null, "requires")) != null) {
            ejbBinding.setRequires(requires);
        }
        return ejbBinding;
    }

    @Override
    public void write(EJBBindingImpl ejbBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "binding.ejb");
        if (ejbBinding.getName() != null) {
            writer.writeAttribute("name", ejbBinding.getName());
        }
        if (ejbBinding.getURI() != null) {
            writer.writeAttribute("uri", ejbBinding.getURI());
        }
        writer.writeEndElement();
    }

    @Override
    public Class<EJBBindingImpl> getModelType() {
        return EJBBindingImpl.class;
    }

    @Override
    public void resolve(EJBBindingImpl ejbBinding, ModelResolver modelResolver) throws ContributionResolveException {
    }
}

