/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.dwr;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.dwr.DWRBinding;
import org.apache.tuscany.sca.binding.dwr.DWRInvoker;
import org.apache.tuscany.sca.binding.dwr.DWRServlet;
import org.apache.tuscany.sca.extension.helper.ComponentLifecycle;
import org.apache.tuscany.sca.extension.helper.InvokerFactory;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

public class DWRInvokerFactory
implements InvokerFactory,
ComponentLifecycle {
    private Binding binding;
    private ServletHost servletHost;

    public DWRInvokerFactory(RuntimeComponent rc, RuntimeComponentReference rcr, Binding b, DWRBinding ab, ServletHost servletHost) {
        this.binding = b;
        this.servletHost = servletHost;
    }

    public Invoker createInvoker(Operation operation) {
        return new DWRInvoker(this.binding.getName(), operation);
    }

    public void start() {
        DWRServlet servlet = (DWRServlet)this.servletHost.getServletMapping("/SCADomain/*");
        if (servlet == null) {
            servlet = new DWRServlet();
            this.servletHost.addServletMapping("/SCADomain/*", (Servlet)servlet);
        }
        servlet.addReference(this.binding.getName());
    }

    public void stop() {
        this.servletHost.removeServletMapping("/SCADomain/*");
    }
}

