/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.dwr;

import java.util.Collection;
import org.apache.tuscany.sca.core.invocation.MessageImpl;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.proxy.dwr.Util;

public class DWRInvoker
implements Invoker {
    private String referenceFunction;

    public DWRInvoker(String referenceName, Operation operation) {
        this.referenceFunction = referenceName + "." + operation.getName();
    }

    public Message invoke(Message requestMsg) {
        this.invoke((Object[])requestMsg.getBody());
        return new MessageImpl();
    }

    public void invoke(Object[] args) {
        WebContext wctx = WebContextFactory.get();
        String currentPage = wctx.getCurrentPage();
        Collection sessions = wctx.getScriptSessionsByPage(currentPage);
        Util utilAll = new Util(sessions);
        ScriptBuffer referenceInvoke = this.getInvokeFragment(args, wctx);
        utilAll.addScript(referenceInvoke);
    }

    protected ScriptBuffer getInvokeFragment(Object[] args, WebContext wctx) {
        ScriptBuffer sb = new ScriptBuffer();
        sb.appendScript(this.referenceFunction);
        sb.appendScript("(");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                sb.appendData(args[i]);
                if (i >= args.length - 1) continue;
                sb.appendScript(", ");
            }
        }
        sb.appendScript(");");
        return sb;
    }
}

