/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.types.util;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeNode;
import org.apache.tuscany.sca.binding.corba.impl.types.util.TypeHelper;
import org.apache.tuscany.sca.binding.corba.impl.types.util.TypeHelpersProxy;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class StructTypeHelper
implements TypeHelper {
    private static final Logger logger = Logger.getLogger(StructTypeHelper.class.getName());

    public Object read(TypeTreeNode node, InputStream is) {
        TypeTreeNode[] children = node.getChildren();
        Object result = null;
        if (children != null) {
            try {
                result = node.getJavaClass().newInstance();
                for (int i = 0; i < children.length; ++i) {
                    Object childResult = TypeHelpersProxy.read(children[i], is);
                    Field childField = result.getClass().getField(children[i].getName());
                    childField.set(result, childResult);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception during reading CORBA struct data", e);
            }
        }
        return result;
    }

    public void write(TypeTreeNode node, OutputStream os, Object data) {
        TypeTreeNode[] children = node.getChildren();
        if (children != null) {
            try {
                for (int i = 0; i < children.length; ++i) {
                    Field childField = node.getJavaClass().getField(children[i].getName());
                    TypeHelpersProxy.write(children[i], os, childField.get(data));
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception during writing CORBA struct data", e);
            }
        }
    }
}

