/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.service;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.RequestConfigurationException;
import org.apache.tuscany.sca.binding.corba.impl.service.InvocationException;
import org.apache.tuscany.sca.binding.corba.impl.service.InvocationProxy;
import org.apache.tuscany.sca.binding.corba.impl.service.OperationTypes;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTree;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeCreator;
import org.apache.tuscany.sca.binding.corba.impl.types.util.TypeHelpersProxy;
import org.apache.tuscany.sca.binding.corba.impl.types.util.Utils;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;

public class DynaCorbaServant
extends ObjectImpl
implements InvokeHandler {
    private static final Logger logger = Logger.getLogger(DynaCorbaServant.class.getName());
    private String[] ids;
    private InvocationProxy invocationProxy;
    private String typeId;

    public DynaCorbaServant(InvocationProxy invocationProxy, String typeId) throws RequestConfigurationException {
        this.invocationProxy = invocationProxy;
        this.typeId = typeId;
        this.setDefaultIds();
    }

    public void setIds(String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] != null && ids[i].length() != 0) continue;
            this.setDefaultIds();
            return;
        }
        this.ids = ids;
    }

    public OutputStream _invoke(String operationName, InputStream in, ResponseHandler rh) {
        OutputStream out;
        OperationTypes types = this.invocationProxy.getOperationTypes(operationName);
        if (types == null) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
        }
        ArrayList<Object> inputInstances = new ArrayList<Object>();
        try {
            for (TypeTree tree : types.getInputType()) {
                Object o = TypeHelpersProxy.read(tree.getRootNode(), in);
                inputInstances.add(o);
            }
        }
        catch (MARSHAL e) {
            throw new BAD_PARAM(0, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            Object result = this.invocationProxy.invoke(operationName, inputInstances);
            out = rh.createReply();
            if (types.getOutputType() != null) {
                TypeTree tree = types.getOutputType();
                TypeHelpersProxy.write(tree.getRootNode(), out, result);
            }
            return out;
        }
        catch (InvocationException ie) {
            try {
                out = rh.createExceptionReply();
                Class<?> exceptionClass = ie.getTargetException().getClass();
                TypeTree tree = TypeTreeCreator.createTypeTree(exceptionClass, null);
                String exceptionId = Utils.getTypeId(exceptionClass);
                out.write_string(exceptionId);
                TypeHelpersProxy.write(tree.getRootNode(), out, ie.getTargetException());
                return out;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception during handling invocation exception", e);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected exception during sending CORBA result to client", e);
        }
        return null;
    }

    public String[] _ids() {
        return this.ids;
    }

    private void setDefaultIds() {
        this.ids = new String[]{this.typeId};
    }
}

