/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.RequestConfigurationException;
import org.apache.tuscany.sca.binding.corba.impl.service.InvocationException;
import org.apache.tuscany.sca.binding.corba.impl.service.InvocationProxy;
import org.apache.tuscany.sca.binding.corba.impl.service.OperationTypes;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTree;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeCreator;
import org.apache.tuscany.sca.binding.corba.impl.util.OperationMapper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInvocationProxy
implements InvocationProxy {
    private RuntimeWire wire;
    private Map<Method, Operation> methodOperationMapping;
    private Map<Operation, Method> operationMethodMapping;
    private Map<String, Method> operationsMap;
    private Map<Operation, OperationTypes> operationsCache = new HashMap<Operation, OperationTypes>();

    public ComponentInvocationProxy(RuntimeComponentService service, RuntimeWire wire, Class<?> javaClass) throws RequestConfigurationException {
        this.wire = wire;
        this.operationsMap = OperationMapper.mapOperationNameToMethod(javaClass);
        this.operationMethodMapping = OperationMapper.mapOperationToMethod(service.getInterfaceContract().getInterface().getOperations(), javaClass);
        this.methodOperationMapping = OperationMapper.mapMethodToOperation(service.getInterfaceContract().getInterface().getOperations(), javaClass);
        this.cacheOperationTypes(service.getInterfaceContract().getInterface().getOperations());
    }

    private void cacheOperationTypes(List<Operation> operations) throws RequestConfigurationException {
        for (Operation operation : operations) {
            OperationTypes operationTypes = new OperationTypes();
            ArrayList<TypeTree> inputInstances = new ArrayList<TypeTree>();
            if (operation.getOutputType() != null && operation.getOutputType().getPhysical() != null && !operation.getOutputType().getPhysical().equals(Void.TYPE)) {
                Annotation[] notes = this.operationMethodMapping.get(operation).getAnnotations();
                TypeTree outputType = TypeTreeCreator.createTypeTree(operation.getOutputType().getPhysical(), notes);
                operationTypes.setOutputType(outputType);
            }
            if (operation.getInputType() != null) {
                Method method = this.operationMethodMapping.get(operation);
                Annotation[][] notes = method.getParameterAnnotations();
                int i = 0;
                for (DataType type : operation.getInputType().getLogical()) {
                    Class<?> forClass = type.getPhysical();
                    TypeTree inputType = TypeTreeCreator.createTypeTree(forClass, notes[i]);
                    inputInstances.add(inputType);
                    ++i;
                }
            }
            operationTypes.setInputType(inputInstances);
            this.operationsCache.put(operation, operationTypes);
        }
    }

    private Operation getOperation4Name(String operationName) {
        Method method = this.operationsMap.get(operationName);
        return this.methodOperationMapping.get(method);
    }

    @Override
    public OperationTypes getOperationTypes(String operationName) {
        return this.operationsCache.get(this.getOperation4Name(operationName));
    }

    @Override
    public Object invoke(String operationName, List<Object> arguments) throws InvocationException {
        Object result = null;
        try {
            result = this.wire.invoke(this.getOperation4Name(operationName), arguments.toArray());
        }
        catch (InvocationTargetException e) {
            InvocationException exception = new InvocationException(e.getCause());
            throw exception;
        }
        return result;
    }
}

