/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl.reference;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.CorbaException;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.RequestConfigurationException;
import org.apache.tuscany.sca.binding.corba.impl.reference.DynaCorbaResponse;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTree;
import org.apache.tuscany.sca.binding.corba.impl.types.TypeTreeCreator;
import org.apache.tuscany.sca.binding.corba.impl.types.util.TypeHelpersProxy;
import org.apache.tuscany.sca.binding.corba.impl.types.util.Utils;
import org.apache.tuscany.sca.binding.corba.impl.util.MethodFinder;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaCorbaRequest {
    private TypeTree returnTree;
    private Map<String, TypeTree> exceptions = new HashMap<String, TypeTree>();
    private InputStream inputStream;
    private ObjectImpl remoteObject;
    private String operation;
    private List<java.lang.Object> arguments = new ArrayList<java.lang.Object>();
    private List<TypeTree> argumentsTypes = new ArrayList<TypeTree>();
    private Class<?> referenceClass;
    private Map<Method, String> operationsMap;

    public DynaCorbaRequest(Object remoteObject, String operation) {
        this.remoteObject = (ObjectImpl)remoteObject;
        this.operation = operation;
    }

    public void setReferenceClass(Class<?> referenceClass) {
        this.referenceClass = referenceClass;
    }

    public void setOperationsMap(Map<Method, String> operationsMap) {
        this.operationsMap = operationsMap;
    }

    public void addArgument(java.lang.Object argument) throws RequestConfigurationException {
        this.addArgument(argument, null);
    }

    public void addArgument(java.lang.Object argument, Annotation[] notes) throws RequestConfigurationException {
        TypeTree tree = TypeTreeCreator.createTypeTree(argument.getClass(), notes);
        this.argumentsTypes.add(tree);
        this.arguments.add(argument);
    }

    private void passArguments(OutputStream outputStream) throws RequestConfigurationException {
        for (int i = 0; i < this.arguments.size(); ++i) {
            TypeTree tree = this.argumentsTypes.get(i);
            TypeHelpersProxy.write(tree.getRootNode(), outputStream, this.arguments.get(i));
        }
    }

    public void setOutputType(Class<?> forClass) throws RequestConfigurationException {
        this.setOutputType(forClass, null);
    }

    public void setOutputType(Class<?> forClass, Annotation[] notes) throws RequestConfigurationException {
        this.returnTree = TypeTreeCreator.createTypeTree(forClass, notes);
    }

    public void addExceptionType(Class<?> forClass) throws RequestConfigurationException {
        TypeTree tree = TypeTreeCreator.createTypeTree(forClass, null);
        String exceptionId = Utils.getTypeId(forClass);
        this.exceptions.put(exceptionId, tree);
    }

    private void handleApplicationException(ApplicationException ae) throws Exception {
        if (this.exceptions.size() == 0) {
            RequestConfigurationException exception = new RequestConfigurationException("ApplicationException occured, but no exception type was specified.", ae.getId());
            throw exception;
        }
        InputStream is = ae.getInputStream();
        String exceptionId = is.read_string();
        TypeTree tree = this.exceptions.get(exceptionId);
        if (tree == null) {
            RequestConfigurationException exception = new RequestConfigurationException("ApplicationException occured, but no such exception was defined", ae.getId());
            throw exception;
        }
        Exception ex = (Exception)TypeHelpersProxy.read(tree.getRootNode(), is);
        throw ex;
    }

    private void handleSystemException(SystemException se) throws Exception {
        if (se instanceof BAD_OPERATION) {
            throw new CorbaException("Bad operation name: " + this.operation, se);
        }
        if (se instanceof BAD_PARAM) {
            throw new CorbaException("Bad parameter", se);
        }
        throw new CorbaException(se.getMessage(), se);
    }

    private String getFinalOperationName() {
        String result = this.operation;
        if (this.referenceClass != null) {
            Class[] argumentTypes = new Class[this.arguments.size()];
            for (int i = 0; i < this.arguments.size(); ++i) {
                argumentTypes[i] = this.arguments.get(i).getClass();
            }
            Method method = MethodFinder.findMethod(this.referenceClass, this.operation, argumentTypes);
            String newOperation = this.operationsMap.get(method);
            if (newOperation != null) {
                result = newOperation;
            }
        }
        return result;
    }

    public DynaCorbaResponse invoke() throws Exception {
        DynaCorbaResponse response = new DynaCorbaResponse();
        String finalOperationName = this.getFinalOperationName();
        OutputStream outputStream = this.remoteObject._request(finalOperationName, true);
        this.passArguments(outputStream);
        try {
            this.inputStream = this.remoteObject._invoke(outputStream);
            if (this.inputStream != null && this.returnTree != null) {
                response.setContent(TypeHelpersProxy.read(this.returnTree.getRootNode(), this.inputStream));
            }
        }
        catch (ApplicationException ae) {
            this.handleApplicationException(ae);
        }
        catch (SystemException se) {
            this.handleSystemException(se);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.release();
        }
        return response;
    }

    private void release() {
        this.remoteObject._releaseReply(this.inputStream);
    }
}

