/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl;

import org.apache.tuscany.sca.binding.corba.CorbaBinding;
import org.apache.tuscany.sca.binding.corba.impl.service.ComponentInvocationProxy;
import org.apache.tuscany.sca.binding.corba.impl.service.DynaCorbaServant;
import org.apache.tuscany.sca.binding.corba.impl.types.util.Utils;
import org.apache.tuscany.sca.host.corba.CorbaHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.omg.CORBA.Object;
import org.osoa.sca.ServiceRuntimeException;

public class CorbaServiceBindingProvider
implements ServiceBindingProvider {
    private CorbaBinding binding;
    private CorbaHost host;
    private RuntimeComponentService service;
    private DynaCorbaServant servant;

    public CorbaServiceBindingProvider(CorbaBinding binding, CorbaHost host, RuntimeComponentService service) {
        this.binding = binding;
        this.host = host;
        this.service = service;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public void start() {
        try {
            Class<?> javaClass = ((JavaInterface)this.service.getInterfaceContract().getInterface()).getJavaClass();
            ComponentInvocationProxy proxy = new ComponentInvocationProxy(this.service, this.service.getRuntimeWire(this.binding), javaClass);
            this.servant = new DynaCorbaServant(proxy, Utils.getTypeId(javaClass));
            this.servant.setIds(new String[]{this.binding.getId()});
            this.host.registerServant(this.binding.getCorbaname(), (Object)this.servant);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.host.unregisterServant(this.binding.getCorbaname());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }
}

