/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tuscany.sca.binding.corba.impl.exceptions.RequestConfigurationException;
import org.apache.tuscany.sca.binding.corba.impl.reference.DynaCorbaRequest;
import org.apache.tuscany.sca.binding.corba.impl.reference.DynaCorbaResponse;
import org.apache.tuscany.sca.binding.corba.impl.util.OperationMapper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.omg.CORBA.Object;
import org.osoa.sca.ServiceRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaInvoker
implements Invoker {
    private Object remoteObject;
    private Class<?> referenceClass;
    private Map<Method, String> operationsMap;
    private Map<Operation, Method> operationMethodMapping;

    public CorbaInvoker(RuntimeComponentReference reference, Object remoteObject, Class<?> referenceClass, Map<Method, String> operationsMap) {
        this.remoteObject = remoteObject;
        this.referenceClass = referenceClass;
        this.operationsMap = operationsMap;
        this.operationMethodMapping = OperationMapper.mapOperationToMethod(reference.getInterfaceContract().getInterface().getOperations(), referenceClass);
    }

    @Override
    public Message invoke(Message msg) {
        try {
            java.lang.Object[] args;
            DynaCorbaRequest request = new DynaCorbaRequest(this.remoteObject, msg.getOperation().getName());
            request.setReferenceClass(this.referenceClass);
            request.setOperationsMap(this.operationsMap);
            if (msg.getOperation().getOutputType() != null) {
                Annotation[] notes = this.operationMethodMapping.get(msg.getOperation()).getAnnotations();
                request.setOutputType(msg.getOperation().getOutputType().getPhysical(), notes);
            }
            if ((args = (java.lang.Object[])msg.getBody()) != null) {
                Annotation[][] notes = this.operationMethodMapping.get(msg.getOperation()).getParameterAnnotations();
                for (int i = 0; i < args.length; ++i) {
                    request.addArgument(args[i], notes[i]);
                }
            }
            if (msg.getOperation().getFaultTypes() != null) {
                for (DataType type : msg.getOperation().getFaultTypes()) {
                    request.addExceptionType(type.getPhysical());
                }
            }
            DynaCorbaResponse response = request.invoke();
            msg.setBody(response.getContent());
        }
        catch (RequestConfigurationException e) {
            throw new ServiceRuntimeException(e);
        }
        catch (Exception e) {
            msg.setFaultBody(e);
        }
        return msg;
    }
}

