/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.binding.atom.AtomBinding;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingListenerServlet;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeWire;

class AtomServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponentService service;
    private AtomBinding binding;
    private ServletHost servletHost;
    private MessageFactory messageFactory;
    private String servletMapping;
    private Mediator mediator;

    AtomServiceBindingProvider(RuntimeComponent component, RuntimeComponentService service, AtomBinding binding, ServletHost servletHost, MessageFactory messageFactory, Mediator mediator) {
        this.service = service;
        this.binding = binding;
        this.servletHost = servletHost;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.service.getInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        RuntimeComponentService componentService = this.service;
        RuntimeWire wire = componentService.getRuntimeWire(this.binding);
        AtomBindingListenerServlet servlet = new AtomBindingListenerServlet(wire, this.messageFactory, this.mediator, this.binding.getTitle());
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, (Servlet)servlet);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }
}

