/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import java.util.Date;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.tuscany.sca.data.collection.Item;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AtomBindingUtil {
    AtomBindingUtil() {
    }

    static org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry(Entry feedEntry, DataType<?> itemClassType, DataType<?> itemXMLType, Mediator mediator) {
        if (feedEntry != null) {
            if (itemClassType.getPhysical() == Item.class) {
                String key = feedEntry.getId().toString();
                Item item = new Item();
                item.setTitle(feedEntry.getTitle());
                item.setContents(feedEntry.getContent());
                for (Link link : feedEntry.getLinks()) {
                    if (link.getRel() == null || "self".equals(link.getRel())) {
                        if (item.getLink() != null) continue;
                        item.setLink(link.getHref().toString());
                        continue;
                    }
                    if ("related".equals(link.getRel())) {
                        item.setRelated(link.getHref().toString());
                        continue;
                    }
                    if (!"alternate".equals(link.getRel())) continue;
                    item.setAlternate(link.getHref().toString());
                }
                item.setDate(feedEntry.getUpdated());
                return new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(key, item);
            }
            String key = null;
            if (feedEntry.getId() != null) {
                key = feedEntry.getId().toString();
            }
            if (feedEntry.getContentElement().getElements().size() == 0) {
                return null;
            }
            String value = feedEntry.getContent();
            Object data = mediator.mediate(value, itemXMLType, itemClassType, null);
            return new org.apache.tuscany.sca.data.collection.Entry<Object, Object>(key, data);
        }
        return null;
    }

    static Entry feedEntry(org.apache.tuscany.sca.data.collection.Entry<Object, Object> entry, DataType<?> itemClassType, DataType<?> itemXMLType, Mediator mediator, Factory factory) {
        Object key = entry.getKey();
        Object data = entry.getData();
        if (data instanceof Item) {
            Date date;
            String alternate;
            String related;
            Item item = (Item)data;
            Entry feedEntry = factory.newEntry();
            if (key != null) {
                feedEntry.setId(key.toString());
            }
            feedEntry.setTitle(item.getTitle());
            feedEntry.setContentAsHtml(item.getContents());
            String href = item.getLink();
            if (href == null && key != null) {
                href = key.toString();
            }
            if (href != null) {
                feedEntry.addLink(href);
            }
            if ((related = item.getRelated()) != null) {
                feedEntry.addLink(related, "related");
            }
            if ((alternate = item.getAlternate()) != null) {
                feedEntry.addLink(alternate, "alternate");
            }
            if ((date = item.getDate()) != null) {
                feedEntry.setUpdated(date);
            }
            return feedEntry;
        }
        if (data != null) {
            Entry feedEntry = factory.newEntry();
            feedEntry.setId(key.toString());
            feedEntry.setTitle("item");
            String value = mediator.mediate(data, itemClassType, itemXMLType, null).toString();
            Content content = factory.newContent();
            content.setContentType(Content.Type.XML);
            content.setValue(value);
            feedEntry.setContentElement(content);
            feedEntry.addLink(key.toString());
            return feedEntry;
        }
        return null;
    }
}

