/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AbstractService;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainingTypeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<ConstrainingType> {
    public ConstrainingTypeProcessor(AssemblyFactory factory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, Monitor monitor) {
        super(factory, policyFactory, extensionProcessor, monitor);
    }

    public ConstrainingTypeProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, Monitor monitor) {
        super(modelFactories.getFactory(AssemblyFactory.class), modelFactories.getFactory(PolicyFactory.class), extensionProcessor, monitor);
    }

    @Override
    public ConstrainingType read(XMLStreamReader reader) throws ContributionReadException {
        ConstrainingType constrainingType = null;
        AbstractService abstractService = null;
        AbstractReference abstractReference = null;
        AbstractProperty abstractProperty = null;
        AbstractContract abstractContract = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        name = reader.getName();
                        if (Constants.CONSTRAINING_TYPE_QNAME.equals(name)) {
                            constrainingType = this.assemblyFactory.createConstrainingType();
                            constrainingType.setName(new QName(this.getString(reader, "targetNamespace"), this.getString(reader, "name")));
                            this.policyProcessor.readPolicies(constrainingType, reader);
                            break;
                        }
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            abstractService = this.assemblyFactory.createAbstractService();
                            abstractContract = abstractService;
                            abstractService.setName(this.getString(reader, "name"));
                            constrainingType.getServices().add(abstractService);
                            this.policyProcessor.readPolicies(abstractService, reader);
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            abstractReference = this.assemblyFactory.createAbstractReference();
                            abstractContract = abstractReference;
                            abstractReference.setName(this.getString(reader, "name"));
                            this.readMultiplicity(abstractReference, reader);
                            constrainingType.getReferences().add(abstractReference);
                            this.policyProcessor.readPolicies(abstractReference, reader);
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            abstractProperty = this.assemblyFactory.createAbstractProperty();
                            this.readAbstractProperty(abstractProperty, reader);
                            Document value = this.readPropertyValue(abstractProperty.getXSDElement(), abstractProperty.getXSDType(), reader);
                            abstractProperty.setValue(value);
                            constrainingType.getProperties().add(abstractProperty);
                            this.policyProcessor.readPolicies(abstractProperty, reader);
                            break;
                        }
                        if (OPERATION_QNAME.equals(name)) {
                            OperationImpl operation = new OperationImpl();
                            operation.setName(this.getString(reader, "name"));
                            operation.setUnresolved(true);
                            this.policyProcessor.readPolicies(abstractContract, operation, reader);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension instanceof InterfaceContract) {
                            abstractContract.setInterfaceContract((InterfaceContract)extension);
                            break;
                        }
                        if (abstractContract != null) {
                            abstractContract.getExtensions().add(extension);
                            break;
                        }
                        constrainingType.getExtensions().add(extension);
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (SERVICE_QNAME.equals(name)) {
                            abstractService = null;
                            abstractContract = null;
                            break;
                        }
                        if (REFERENCE_QNAME.equals(name)) {
                            abstractReference = null;
                            abstractContract = null;
                            break;
                        }
                        if (!PROPERTY_QNAME.equals(name)) break;
                        abstractProperty = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error("XMLStreamException", (Object)reader, ex);
        }
        return constrainingType;
    }

    @Override
    public void write(ConstrainingType constrainingType, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, "constrainingType", new BaseStAXArtifactProcessor.XAttr("targetNamespace", constrainingType.getName().getNamespaceURI()), new BaseStAXArtifactProcessor.XAttr("name", constrainingType.getName().getLocalPart()), this.policyProcessor.writePolicies(constrainingType));
        for (AbstractService service : constrainingType.getServices()) {
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
            this.extensionProcessor.write(service.getInterfaceContract(), writer);
            for (Object extension : service.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (AbstractReference reference : constrainingType.getReferences()) {
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), this.writeMultiplicity(reference), this.policyProcessor.writePolicies(reference));
            this.extensionProcessor.write(reference.getInterfaceContract(), writer);
            for (Object extension : reference.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (AbstractProperty abstractProperty : constrainingType.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", abstractProperty.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", abstractProperty.isMustSupply()), new BaseStAXArtifactProcessor.XAttr("many", abstractProperty.isMany()), new BaseStAXArtifactProcessor.XAttr("type", abstractProperty.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", abstractProperty.getXSDElement()), this.policyProcessor.writePolicies(abstractProperty));
            this.writePropertyValue(abstractProperty.getValue(), abstractProperty.getXSDElement(), abstractProperty.getXSDType(), writer);
            for (Object extension : abstractProperty.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Object extension : constrainingType.getExtensions()) {
            this.extensionProcessor.write(extension, writer);
        }
        this.writeEndDocument(writer);
    }

    @Override
    public void resolve(ConstrainingType constrainingType, ModelResolver resolver) throws ContributionResolveException {
        this.resolveAbstractContracts(constrainingType.getServices(), resolver);
        this.resolveAbstractContracts(constrainingType.getReferences(), resolver);
        this.resolveIntents(constrainingType.getRequiredIntents(), resolver);
        for (AbstractService service : constrainingType.getServices()) {
            this.resolveIntents(service.getRequiredIntents(), resolver);
        }
        for (AbstractReference reference : constrainingType.getReferences()) {
            this.resolveIntents(reference.getRequiredIntents(), resolver);
        }
    }

    @Override
    public QName getArtifactType() {
        return CONSTRAINING_TYPE_QNAME;
    }

    @Override
    public Class<ConstrainingType> getModelType() {
        return ConstrainingType.class;
    }
}

