/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainingTypeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<ConstrainingType> {
    private XMLInputFactory inputFactory;

    public ConstrainingTypeDocumentProcessor(StAXArtifactProcessor staxProcessor, XMLInputFactory inputFactory, Monitor monitor) {
        super(null, null, staxProcessor, monitor);
        this.inputFactory = inputFactory;
    }

    public ConstrainingTypeDocumentProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        super(null, null, staxProcessor, monitor);
        this.inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
    }

    @Override
    public ConstrainingType read(URL contributionURL, URI uri, URL url) throws ContributionReadException {
        InputStream urlStream = null;
        try {
            ConstrainingType constrainingType;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            urlStream = connection.getInputStream();
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            reader.nextTag();
            ConstrainingType constrainingType2 = constrainingType = (ConstrainingType)this.extensionProcessor.read(reader);
            return constrainingType2;
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
        catch (IOException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void resolve(ConstrainingType constrainingType, ModelResolver resolver) throws ContributionResolveException {
        this.extensionProcessor.resolve(constrainingType, resolver);
    }

    @Override
    public String getArtifactType() {
        return ".constrainingType";
    }

    @Override
    public Class<ConstrainingType> getModelType() {
        return ConstrainingType.class;
    }
}

