/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointFactory;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReferenceConfigurationUtil {
    ReferenceConfigurationUtil() {
    }

    private static void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            ProblemImpl problem = new ProblemImpl(ReferenceConfigurationUtil.class.getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    static boolean isValidMultiplicityOverride(Multiplicity definedMul, Multiplicity overridenMul) {
        if (definedMul != overridenMul) {
            switch (definedMul) {
                case ZERO_N: {
                    return overridenMul == Multiplicity.ZERO_ONE;
                }
                case ONE_N: {
                    return overridenMul == Multiplicity.ONE_ONE;
                }
            }
            return false;
        }
        return true;
    }

    static boolean validateMultiplicityAndTargets(Multiplicity multiplicity, List<?> targets, List<Binding> bindings) {
        int count = targets.size();
        if (multiplicity == null) {
            return true;
        }
        switch (multiplicity) {
            case ZERO_N: {
                break;
            }
            case ZERO_ONE: {
                if (count <= 1) break;
                return false;
            }
            case ONE_ONE: {
                if (count == 1) break;
                if (count == 0) {
                    for (Binding binding : bindings) {
                        if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                        return true;
                    }
                }
                return false;
            }
            case ONE_N: {
                if (count >= 1) break;
                if (count == 0) {
                    for (Binding binding : bindings) {
                        if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    static List<ComponentReference> getPromotedComponentReferences(CompositeReference compositeReference) {
        ArrayList<ComponentReference> componentReferences = new ArrayList<ComponentReference>();
        ReferenceConfigurationUtil.collectPromotedComponentReferences(compositeReference, componentReferences);
        return componentReferences;
    }

    private static void collectPromotedComponentReferences(CompositeReference compositeReference, List<ComponentReference> componentReferences) {
        for (ComponentReference componentReference : compositeReference.getPromotedReferences()) {
            Reference reference = componentReference.getReference();
            if (reference instanceof CompositeReference) {
                ReferenceConfigurationUtil.collectPromotedComponentReferences((CompositeReference)reference, componentReferences);
                continue;
            }
            if (reference == null) continue;
            componentReferences.add(componentReference);
        }
    }

    static void reconcileReferenceBindings(Reference reference, ComponentReference promotedReference, AssemblyFactory assemblyFactory, EndpointFactory endpointFactory, Monitor monitor) {
        if (promotedReference.getMultiplicity() == Multiplicity.ONE_ONE || promotedReference.getMultiplicity() == Multiplicity.ZERO_ONE) {
            if (reference.getBindings().size() > 0) {
                ArrayList<Binding> bindingsToCopyDown = new ArrayList<Binding>();
                ArrayList<Endpoint> endpointsToCopyDown = new ArrayList<Endpoint>();
                block0: for (Binding binding : reference.getBindings()) {
                    if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                    bindingsToCopyDown.add(binding);
                    if (reference instanceof ComponentReference) {
                        for (Endpoint endpoint : ((ComponentReference)reference).getEndpoints()) {
                            if (endpoint.getSourceBinding() != binding) continue;
                            endpointsToCopyDown.add(endpoint);
                            continue block0;
                        }
                        continue;
                    }
                    Endpoint endpoint = endpointFactory.createEndpoint();
                    endpoint.setTargetName(binding.getURI());
                    endpoint.setSourceComponent(null);
                    endpoint.setSourceComponentReference(promotedReference);
                    endpoint.setInterfaceContract(reference.getInterfaceContract());
                    endpoint.setSourceBinding(binding);
                    endpointsToCopyDown.add(endpoint);
                }
                if (bindingsToCopyDown.size() > 0) {
                    promotedReference.getBindings().clear();
                    promotedReference.getBindings().addAll(bindingsToCopyDown);
                    promotedReference.getEndpoints().clear();
                    promotedReference.getEndpoints().addAll(endpointsToCopyDown);
                }
            }
            if (promotedReference.getBindings().size() > 1) {
                ReferenceConfigurationUtil.warning(monitor, "ComponentReferenceMoreWire", promotedReference, promotedReference.getName());
            }
        } else if (reference.getBindings().size() > 0) {
            block2: for (Binding binding : reference.getBindings()) {
                if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
                promotedReference.getBindings().add(binding);
                if (reference instanceof ComponentReference) {
                    for (Endpoint endpoint : ((ComponentReference)reference).getEndpoints()) {
                        if (endpoint.getSourceBinding() != binding) continue;
                        promotedReference.getEndpoints().add(endpoint);
                        continue block2;
                    }
                    continue;
                }
                Endpoint endpoint = endpointFactory.createEndpoint();
                endpoint.setTargetName(binding.getURI());
                endpoint.setSourceComponent(null);
                endpoint.setSourceComponentReference(promotedReference);
                endpoint.setInterfaceContract(reference.getInterfaceContract());
                endpoint.setSourceBinding(binding);
                promotedReference.getEndpoints().add(endpoint);
            }
        }
        HashSet<Binding> callbackBindings = new HashSet<Binding>();
        if (promotedReference.getCallback() != null) {
            callbackBindings.addAll(promotedReference.getCallback().getBindings());
        }
        if (reference.getCallback() != null) {
            callbackBindings.addAll(reference.getCallback().getBindings());
        }
        promotedReference.setCallback(assemblyFactory.createCallback());
        for (Binding binding : callbackBindings) {
            if (binding instanceof OptimizableBinding && binding.getURI() == null) continue;
            promotedReference.getCallback().getBindings().add(binding);
        }
    }
}

