/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.impl.PolicyConfigurationException;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.QualifiedIntent;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;
import org.apache.tuscany.sca.policy.util.PolicyValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PolicyConfigurationUtil {
    PolicyConfigurationUtil() {
    }

    private static List<Intent> computeInheritableIntents(IntentAttachPointType attachPointType, List<Intent> inheritableIntents) throws PolicyValidationException {
        ArrayList<Intent> validInheritableIntents = new ArrayList<Intent>();
        PolicyComputationUtils.expandProfileIntents(inheritableIntents);
        block0: for (Intent intent : inheritableIntents) {
            if (!intent.isUnresolved()) {
                for (QName constrained : intent.getConstrains()) {
                    if (!PolicyValidationUtils.isConstrained(constrained, attachPointType)) continue;
                    validInheritableIntents.add(intent);
                    continue block0;
                }
                continue;
            }
            throw new PolicyValidationException("Policy Intent '" + intent.getName() + "' is not defined in this domain");
        }
        return validInheritableIntents;
    }

    private static void normalizeIntents(IntentAttachPoint intentAttachPoint) {
        PolicyComputationUtils.expandProfileIntents(intentAttachPoint.getRequiredIntents());
        PolicyConfigurationUtil.filterDuplicatesAndQualifiableIntents(intentAttachPoint);
    }

    private static void trimInherentlyProvidedIntents(IntentAttachPointType attachPointType, List<Intent> intents) {
        ArrayList<Intent> requiredIntents = new ArrayList<Intent>(intents);
        for (Intent intent : requiredIntents) {
            if (!PolicyConfigurationUtil.isProvidedInherently(attachPointType, intent)) continue;
            intents.remove(intent);
        }
    }

    static void computeIntentsForOperations(IntentAttachPoint intentAttachPoint) throws PolicyValidationException {
        if (intentAttachPoint instanceof OperationsConfigurator) {
            PolicyConfigurationUtil.computeIntentsForOperations((OperationsConfigurator)((Object)intentAttachPoint), intentAttachPoint, intentAttachPoint.getRequiredIntents());
        }
    }

    private static void computeIntentsForOperations(OperationsConfigurator opConfigurator, IntentAttachPoint intentAttachPoint, List<Intent> parentIntents) throws PolicyValidationException {
        IntentAttachPointType attachPointType = intentAttachPoint.getType();
        boolean found = false;
        for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
            PolicyComputationUtils.expandProfileIntents(confOp.getRequiredIntents());
            Intent tempIntent = null;
            ArrayList<Intent> attachPointOpIntents = new ArrayList<Intent>();
            for (Intent anIntent : parentIntents) {
                found = false;
                tempIntent = anIntent;
                while (tempIntent instanceof QualifiedIntent) {
                    tempIntent = ((QualifiedIntent)tempIntent).getQualifiableIntent();
                }
                for (Intent opIntent : confOp.getRequiredIntents()) {
                    if (!opIntent.getName().getLocalPart().startsWith(tempIntent.getName().getLocalPart())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean conflict = false;
                for (Intent excluded : anIntent.getExcludedIntents()) {
                    if (!confOp.getRequiredIntents().contains(excluded)) continue;
                    conflict = true;
                    break;
                }
                if (conflict) continue;
                attachPointOpIntents.add(anIntent);
            }
            confOp.getRequiredIntents().addAll(attachPointOpIntents);
            PolicyConfigurationUtil.filterDuplicatesAndQualifiableIntents(confOp);
            if (attachPointType == null) continue;
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>(confOp.getRequiredIntents());
            for (Intent intent : requiredIntents) {
                if (!PolicyConfigurationUtil.isProvidedInherently(attachPointType, intent)) continue;
                confOp.getRequiredIntents().remove(intent);
            }
        }
    }

    private static List<PolicySet> computeInheritablePolicySets(List<PolicySet> inheritablePolicySets, List<PolicySet> applicablePolicySets) throws PolicyValidationException {
        ArrayList<PolicySet> validInheritablePolicySets = new ArrayList<PolicySet>();
        for (PolicySet policySet : inheritablePolicySets) {
            if (!policySet.isUnresolved()) {
                if (!applicablePolicySets.contains(policySet)) continue;
                validInheritablePolicySets.add(policySet);
                continue;
            }
            throw new PolicyValidationException("Policy Set '" + policySet.getName() + "' is not defined in this domain  ");
        }
        return validInheritablePolicySets;
    }

    private static void normalizePolicySets(PolicySetAttachPoint policySetAttachPoint) {
        HashMap<QName, PolicySet> policySetTable = new HashMap<QName, PolicySet>();
        for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
            policySetTable.put(policySet.getName(), policySet);
        }
        policySetAttachPoint.getPolicySets().clear();
        policySetAttachPoint.getPolicySets().addAll(policySetTable.values());
        for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
            PolicyComputationUtils.expandProfileIntents(policySet.getProvidedIntents());
        }
    }

    private static void computePolicySetsForOperations(List<PolicySet> applicablePolicySets, PolicySetAttachPoint policySetAttachPoint) throws PolicyValidationException {
        if (policySetAttachPoint instanceof OperationsConfigurator) {
            PolicyConfigurationUtil.computePolicySetsForOperations(applicablePolicySets, (OperationsConfigurator)((Object)policySetAttachPoint), policySetAttachPoint);
        }
    }

    private static void computePolicySetsForOperations(List<PolicySet> applicablePolicySets, OperationsConfigurator opConfigurator, PolicySetAttachPoint policySetAttachPoint) throws PolicyValidationException {
        HashMap<QName, PolicySet> policySetTable = new HashMap<QName, PolicySet>();
        IntentAttachPointType attachPointType = policySetAttachPoint.getType();
        for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
            for (PolicySet policySet : confOp.getPolicySets()) {
                if (!policySet.isUnresolved()) {
                    if (applicablePolicySets.contains(policySet)) continue;
                    throw new PolicyValidationException("Policy Set '" + policySet.getName() + " specified for operation " + confOp.getName() + "' does not constrain extension type  " + attachPointType.getName());
                }
                throw new PolicyValidationException("Policy Set '" + policySet.getName() + " specified for operation " + confOp.getName() + "' is not defined in this domain  ");
            }
            for (PolicySet policySet : confOp.getPolicySets()) {
                policySetTable.put(policySet.getName(), policySet);
            }
            confOp.getPolicySets().clear();
            confOp.getPolicySets().addAll(policySetTable.values());
            policySetTable.clear();
            for (PolicySet policySet : confOp.getPolicySets()) {
                PolicyComputationUtils.expandProfileIntents(policySet.getProvidedIntents());
            }
        }
    }

    private static void trimProvidedIntents(List<Intent> requiredIntents, List<PolicySet> policySets) {
        for (PolicySet policySet : policySets) {
            PolicyConfigurationUtil.trimProvidedIntents(requiredIntents, policySet);
        }
    }

    private static void determineApplicableDomainPolicySets(List<PolicySet> applicablePolicySets, PolicySetAttachPoint policySetAttachPoint, IntentAttachPointType intentAttachPointType) {
        if (policySetAttachPoint.getRequiredIntents().size() > 0) {
            ArrayList<Intent> combinedTargetIntents = new ArrayList<Intent>();
            combinedTargetIntents.addAll(policySetAttachPoint.getRequiredIntents());
            for (PolicySet targetPolicySet : policySetAttachPoint.getPolicySets()) {
                combinedTargetIntents.addAll(PolicyComputationUtils.findAndExpandProfileIntents(targetPolicySet.getProvidedIntents()));
            }
            for (PolicySet policySet : applicablePolicySets) {
                boolean conflict = false;
                List<Intent> providedIntents = PolicyComputationUtils.findAndExpandProfileIntents(policySet.getProvidedIntents());
                block2: for (Intent intent : providedIntents) {
                    for (Intent excluded : intent.getExcludedIntents()) {
                        if (!combinedTargetIntents.contains(excluded)) continue;
                        conflict = true;
                        break block2;
                    }
                }
                if (conflict) continue;
                int prevSize = policySetAttachPoint.getRequiredIntents().size();
                PolicyConfigurationUtil.trimProvidedIntents(policySetAttachPoint.getRequiredIntents(), policySet);
                if (prevSize == policySetAttachPoint.getRequiredIntents().size()) continue;
                policySetAttachPoint.getPolicySets().add(policySet);
            }
        }
    }

    private static boolean isProvidedInherently(IntentAttachPointType attachPointType, Intent intent) {
        return attachPointType != null && (attachPointType.getAlwaysProvidedIntents() != null && attachPointType.getAlwaysProvidedIntents().contains(intent) || attachPointType.getMayProvideIntents() != null && attachPointType.getMayProvideIntents().contains(intent));
    }

    private static void trimProvidedIntents(List<Intent> requiredIntents, PolicySet policySet) {
        for (Intent providedIntent : policySet.getProvidedIntents()) {
            if (!requiredIntents.contains(providedIntent)) continue;
            requiredIntents.remove(providedIntent);
        }
        for (Intent mappedIntent : policySet.getMappedPolicies().keySet()) {
            if (!requiredIntents.contains(mappedIntent)) continue;
            requiredIntents.remove(mappedIntent);
        }
    }

    private static void filterDuplicatesAndQualifiableIntents(IntentAttachPoint intentAttachPoint) {
        HashMap<QName, Intent> intentsTable = new HashMap<QName, Intent>();
        for (Intent intent : intentAttachPoint.getRequiredIntents()) {
            intentsTable.put(intent.getName(), intent);
        }
        HashMap intentsTableCopy = new HashMap(intentsTable);
        for (Intent intent : intentsTableCopy.values()) {
            QualifiedIntent qualifiedIntent;
            if (!(intent instanceof QualifiedIntent) || intentsTable.get((qualifiedIntent = (QualifiedIntent)intent).getQualifiableIntent().getName()) == null) continue;
            intentsTable.remove(qualifiedIntent.getQualifiableIntent().getName());
        }
        intentAttachPoint.getRequiredIntents().clear();
        intentAttachPoint.getRequiredIntents().addAll(intentsTable.values());
    }

    private static void validateIntents(ConfiguredOperation confOp, IntentAttachPointType attachPointType) throws PolicyValidationException {
        boolean found = false;
        if (attachPointType != null) {
            found = false;
            for (Intent intent : confOp.getRequiredIntents()) {
                if (!intent.isUnresolved()) {
                    for (QName constrained : intent.getConstrains()) {
                        if (!PolicyValidationUtils.isConstrained(constrained, attachPointType)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new PolicyValidationException("Policy Intent '" + intent.getName() + " specified for operation " + confOp.getName() + "' does not constrain extension type  " + attachPointType.getName());
                }
                throw new PolicyValidationException("Policy Intent '" + intent.getName() + " specified for operation " + confOp.getName() + "' is not defined in this domain  ");
            }
        }
    }

    static void computeBindingIntentsAndPolicySets(Contract contract) throws PolicyValidationException {
        PolicySetAttachPoint policiedBinding;
        for (Binding binding : contract.getBindings()) {
            if (!(binding instanceof PolicySetAttachPoint)) continue;
            policiedBinding = (PolicySetAttachPoint)((Object)binding);
            PolicyConfigurationUtil.computeIntents((IntentAttachPoint)((Object)binding), contract.getRequiredIntents());
            PolicyConfigurationUtil.aggregateAndPruneApplicablePolicySets(contract.getApplicablePolicySets(), policiedBinding.getApplicablePolicySets());
            PolicyConfigurationUtil.computePolicySets(policiedBinding, contract.getPolicySets());
            PolicyComputationUtils.checkForMutuallyExclusiveIntents(policiedBinding.getRequiredIntents(), policiedBinding.getPolicySets(), policiedBinding.getType(), contract.getName());
            if (!(binding instanceof OperationsConfigurator) || !(contract instanceof OperationsConfigurator)) continue;
            PolicyConfigurationUtil.addInheritedOpConfOnBindings(contract, (OperationsConfigurator)((Object)binding), (PolicySetAttachPoint)((Object)binding));
            PolicyConfigurationUtil.computeIntentsForOperations((IntentAttachPoint)((Object)binding));
            PolicyConfigurationUtil.computePolicySetsForOperations(contract.getApplicablePolicySets(), policiedBinding);
            for (ConfiguredOperation confOp : ((OperationsConfigurator)((Object)binding)).getConfiguredOperations()) {
                PolicyComputationUtils.checkForMutuallyExclusiveIntents(confOp.getRequiredIntents(), confOp.getPolicySets(), policiedBinding.getType(), contract.getName() + "." + confOp.getName());
            }
        }
        if (contract.getCallback() != null) {
            for (Binding binding : contract.getCallback().getBindings()) {
                if (!(binding instanceof PolicySetAttachPoint)) continue;
                policiedBinding = (PolicySetAttachPoint)((Object)binding);
                PolicyConfigurationUtil.computeIntents((IntentAttachPoint)((Object)binding), contract.getCallback().getRequiredIntents());
                PolicyConfigurationUtil.aggregateAndPruneApplicablePolicySets(contract.getApplicablePolicySets(), policiedBinding.getApplicablePolicySets());
                PolicyConfigurationUtil.computePolicySets(policiedBinding, contract.getCallback().getPolicySets());
                PolicyComputationUtils.checkForMutuallyExclusiveIntents(policiedBinding.getRequiredIntents(), policiedBinding.getPolicySets(), policiedBinding.getType(), contract.getName() + " callback");
            }
        }
    }

    private static void computeIntents(IntentAttachPoint policiedBinding, List<Intent> inheritedIntents) throws PolicyValidationException {
        List<Intent> prunedIntents = PolicyConfigurationUtil.computeInheritableIntents(policiedBinding.getType(), inheritedIntents);
        policiedBinding.getRequiredIntents().addAll(prunedIntents);
        PolicyConfigurationUtil.normalizeIntents(policiedBinding);
    }

    private static void computePolicySets(PolicySetAttachPoint policiedBinding, List<PolicySet> inheritedPolicySets) throws PolicyValidationException {
        List<PolicySet> prunedPolicySets = PolicyConfigurationUtil.computeInheritablePolicySets(inheritedPolicySets, policiedBinding.getApplicablePolicySets());
        policiedBinding.getPolicySets().addAll(prunedPolicySets);
        PolicyConfigurationUtil.normalizePolicySets(policiedBinding);
    }

    static void determineApplicableBindingPolicySets(Contract source, Contract target) throws PolicyConfigurationException {
        ArrayList<Intent> intentsCopy = null;
        for (Binding aBinding : source.getBindings()) {
            if (!(aBinding instanceof PolicySetAttachPoint)) continue;
            PolicySetAttachPoint policiedBinding = (PolicySetAttachPoint)((Object)aBinding);
            IntentAttachPointType bindingType = policiedBinding.getType();
            intentsCopy = new ArrayList<Intent>(policiedBinding.getRequiredIntents());
            if (target != null) {
                block1: for (Intent intent : target.getRequiredIntents()) {
                    if (policiedBinding.getRequiredIntents().contains(intent)) continue;
                    for (QName constrained : intent.getConstrains()) {
                        if (bindingType == null || !bindingType.getName().getNamespaceURI().equals(constrained.getNamespaceURI()) || !bindingType.getName().getLocalPart().startsWith(constrained.getLocalPart())) continue;
                        policiedBinding.getRequiredIntents().add(intent);
                        continue block1;
                    }
                }
            }
            if (aBinding instanceof OperationsConfigurator) {
                OperationsConfigurator opConfigurator = (OperationsConfigurator)((Object)aBinding);
                for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
                    ArrayList<Intent> opsIntentsCopy = new ArrayList<Intent>(confOp.getRequiredIntents());
                    PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedBinding.getType(), confOp.getRequiredIntents());
                    PolicyConfigurationUtil.trimProvidedIntents(confOp.getRequiredIntents(), confOp.getPolicySets());
                    PolicyConfigurationUtil.trimProvidedIntents(confOp.getRequiredIntents(), policiedBinding.getPolicySets());
                    PolicyConfigurationUtil.determineApplicableDomainPolicySets(policiedBinding.getApplicablePolicySets(), confOp, policiedBinding.getType());
                    if (confOp.getRequiredIntents().size() > 0) {
                        throw new PolicyConfigurationException("The following are unfulfilled intents for operations configured in binding - " + aBinding.getName() + "\nUnfulfilled Intents = " + confOp.getRequiredIntents());
                    }
                    confOp.getRequiredIntents().clear();
                    confOp.getRequiredIntents().addAll(opsIntentsCopy);
                }
            }
            PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedBinding.getType(), policiedBinding.getRequiredIntents());
            PolicyConfigurationUtil.trimProvidedIntents(policiedBinding.getRequiredIntents(), policiedBinding.getPolicySets());
            PolicyConfigurationUtil.determineApplicableDomainPolicySets(source, policiedBinding);
            policiedBinding.getRequiredIntents().clear();
            policiedBinding.getRequiredIntents().addAll(intentsCopy);
        }
    }

    private static void determineApplicableDomainPolicySets(Contract contract, PolicySetAttachPoint policiedBinding) throws PolicyConfigurationException {
        PolicyConfigurationUtil.determineApplicableDomainPolicySets(policiedBinding.getApplicablePolicySets(), policiedBinding, policiedBinding.getType());
        if (policiedBinding.getRequiredIntents().size() > 0) {
            if (contract instanceof Service) {
                throw new PolicyConfigurationException("The following are unfulfilled intents for binding in service - " + contract.getName() + "\nUnfulfilled Intents = " + policiedBinding.getRequiredIntents());
            }
            throw new PolicyConfigurationException("The are unfulfilled intents for binding in reference - " + contract.getName() + "\nUnfulfilled Intents = " + policiedBinding.getRequiredIntents());
        }
    }

    private static void addInheritedOpConfOnBindings(OperationsConfigurator source, OperationsConfigurator target, PolicySetAttachPoint attachPoint) throws PolicyValidationException {
        boolean found = false;
        ArrayList<ConfiguredOperation> additionalOperations = new ArrayList<ConfiguredOperation>();
        for (ConfiguredOperation sourceConfOp : source.getConfiguredOperations()) {
            for (ConfiguredOperation targetConfOp : target.getConfiguredOperations()) {
                if (!sourceConfOp.getName().equals(targetConfOp.getName())) continue;
                List<Intent> prunedIntents = PolicyConfigurationUtil.computeInheritableIntents(attachPoint.getType(), sourceConfOp.getRequiredIntents());
                PolicyComputationUtils.addInheritedIntents(prunedIntents, targetConfOp.getRequiredIntents());
                List<PolicySet> prunedPolicySets = PolicyConfigurationUtil.computeInheritablePolicySets(sourceConfOp.getPolicySets(), attachPoint.getApplicablePolicySets());
                PolicyComputationUtils.addInheritedPolicySets(prunedPolicySets, targetConfOp.getPolicySets(), true);
                found = true;
                break;
            }
            if (found) continue;
            additionalOperations.add(sourceConfOp);
        }
        if (!additionalOperations.isEmpty()) {
            target.getConfiguredOperations().addAll(additionalOperations);
        }
    }

    private static void aggregateAndPruneApplicablePolicySets(List<PolicySet> source, List<PolicySet> target) {
        target.addAll(source);
        Hashtable<QName, PolicySet> policySetTable = new Hashtable<QName, PolicySet>();
        for (PolicySet policySet : target) {
            policySetTable.put(policySet.getName(), policySet);
        }
        target.clear();
        target.addAll(policySetTable.values());
    }

    static <C extends Contract> void inheritDefaultPolicies(Base parent, List<C> contracts) {
        for (Contract contract : contracts) {
            if (parent instanceof PolicySetAttachPoint) {
                PolicyComputationUtils.addDefaultPolicies(((PolicySetAttachPoint)((Object)parent)).getRequiredIntents(), ((PolicySetAttachPoint)((Object)parent)).getPolicySets(), contract.getRequiredIntents(), contract.getPolicySets());
            }
            for (ConfiguredOperation confOp : contract.getConfiguredOperations()) {
                PolicyComputationUtils.addDefaultPolicies(contract.getRequiredIntents(), contract.getPolicySets(), confOp.getRequiredIntents(), confOp.getPolicySets());
            }
            if (contract.getCallback() == null) continue;
            PolicyComputationUtils.addDefaultPolicies(contract.getRequiredIntents(), contract.getPolicySets(), contract.getCallback().getRequiredIntents(), contract.getCallback().getPolicySets());
        }
    }

    static void computeImplementationIntentsAndPolicySets(Implementation implementation, Component parent) throws PolicyValidationException, PolicyConfigurationException {
        if (implementation instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedImplementation = (PolicySetAttachPoint)((Object)implementation);
            List<Intent> prunedIntents = PolicyConfigurationUtil.computeInheritableIntents(policiedImplementation.getType(), parent.getRequiredIntents());
            parent.getRequiredIntents().clear();
            parent.getRequiredIntents().addAll(prunedIntents);
            PolicyConfigurationUtil.normalizeIntents(parent);
            PolicyConfigurationUtil.computeIntentsForOperations((OperationsConfigurator)((Object)parent), (IntentAttachPoint)((Object)implementation), parent.getRequiredIntents());
            List<PolicySet> prunedPolicySets = PolicyConfigurationUtil.computeInheritablePolicySets(parent.getPolicySets(), parent.getApplicablePolicySets());
            parent.getPolicySets().clear();
            parent.getPolicySets().addAll(prunedPolicySets);
            PolicyConfigurationUtil.normalizePolicySets(parent);
            PolicyComputationUtils.checkForMutuallyExclusiveIntents(parent.getRequiredIntents(), parent.getPolicySets(), policiedImplementation.getType(), parent.getName());
            PolicyConfigurationUtil.computePolicySetsForOperations(parent.getApplicablePolicySets(), (OperationsConfigurator)((Object)parent), (PolicySetAttachPoint)((Object)implementation));
            for (ConfiguredOperation confOp : ((OperationsConfigurator)((Object)parent)).getConfiguredOperations()) {
                PolicyComputationUtils.checkForMutuallyExclusiveIntents(confOp.getRequiredIntents(), confOp.getPolicySets(), policiedImplementation.getType(), parent.getName() + "." + confOp.getName());
            }
            PolicyConfigurationUtil.determineApplicableImplementationPolicySets(parent);
        }
    }

    private static void determineApplicableImplementationPolicySets(Component component) throws PolicyConfigurationException {
        ArrayList<Intent> intentsCopy = null;
        if (component.getImplementation() instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedImplementation = (PolicySetAttachPoint)((Object)component.getImplementation());
            if (component instanceof OperationsConfigurator) {
                OperationsConfigurator opConfigurator = (OperationsConfigurator)((Object)component);
                for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
                    intentsCopy = new ArrayList<Intent>(confOp.getRequiredIntents());
                    PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedImplementation.getType(), confOp.getRequiredIntents());
                    PolicyConfigurationUtil.trimProvidedIntents(confOp.getRequiredIntents(), confOp.getPolicySets());
                    PolicyConfigurationUtil.trimProvidedIntents(confOp.getRequiredIntents(), component.getPolicySets());
                    PolicyConfigurationUtil.determineApplicableDomainPolicySets(component.getApplicablePolicySets(), confOp, policiedImplementation.getType());
                    if (confOp.getRequiredIntents().size() > 0) {
                        throw new PolicyConfigurationException("The following are unfulfilled intents for operations configured in component implementation - " + component.getName() + "\nUnfulfilled Intents = " + confOp.getRequiredIntents());
                    }
                    confOp.getRequiredIntents().clear();
                    confOp.getRequiredIntents().addAll(intentsCopy);
                }
            }
            intentsCopy = new ArrayList<Intent>(component.getRequiredIntents());
            PolicyConfigurationUtil.trimInherentlyProvidedIntents(policiedImplementation.getType(), component.getRequiredIntents());
            PolicyConfigurationUtil.trimProvidedIntents(component.getRequiredIntents(), component.getPolicySets());
            PolicyConfigurationUtil.determineApplicableDomainPolicySets(component.getApplicablePolicySets(), component, policiedImplementation.getType());
            if (component.getRequiredIntents().size() > 0) {
                throw new PolicyConfigurationException("The following are unfulfilled intents for component implementation - " + component.getName() + "\nUnfulfilled Intents = " + component.getRequiredIntents());
            }
            component.getRequiredIntents().clear();
            component.getRequiredIntents().addAll(intentsCopy);
        }
    }
}

