/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.builder.EndpointBuilder;
import org.apache.tuscany.sca.assembly.builder.impl.BindingConfigurationUtil;
import org.apache.tuscany.sca.assembly.builder.impl.PolicyConfigurationUtil;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public abstract class EndpointBuilderImpl
implements EndpointBuilder {
    private Monitor monitor;

    public EndpointBuilderImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    private void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = null;
            problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    public void build(Endpoint endpoint) {
        CompositeService compositeService;
        ComponentService promotedComponentService;
        if (endpoint.getTargetComponentService() == null) {
            return;
        }
        boolean bidirectional = false;
        if (endpoint.getSourceComponentReference().getInterfaceContract() != null && endpoint.getSourceComponentReference().getInterfaceContract().getCallbackInterface() != null) {
            bidirectional = true;
        }
        if (endpoint.getTargetComponentService().getService() instanceof CompositeService && (promotedComponentService = ServiceConfigurationUtil.getPromotedComponentService(compositeService = (CompositeService)endpoint.getTargetComponentService().getService())) != null && !promotedComponentService.isUnresolved()) {
            endpoint.setTargetComponentService(promotedComponentService);
        }
        try {
            PolicyConfigurationUtil.determineApplicableBindingPolicySets(endpoint.getSourceComponentReference(), endpoint.getTargetComponentService());
        }
        catch (Exception e) {
            this.error("PolicyRelatedException", endpoint, e);
        }
        Binding resolvedBinding = BindingConfigurationUtil.matchBinding(endpoint.getTargetComponent(), endpoint.getTargetComponentService(), endpoint.getCandidateBindings(), endpoint.getTargetComponentService().getBindings());
        if (resolvedBinding == null) {
            this.warning("NoMatchingBinding", endpoint.getSourceComponentReference(), endpoint.getSourceComponentReference().getName(), endpoint.getTargetComponentService().getName());
        } else {
            endpoint.setSourceBinding(resolvedBinding);
        }
        if (bidirectional) {
            Binding resolvedCallbackBinding = BindingConfigurationUtil.matchBinding(endpoint.getTargetComponent(), endpoint.getTargetComponentService(), endpoint.getSourceComponentReference().getCallback().getBindings(), endpoint.getTargetComponentService().getCallback().getBindings());
            if (resolvedBinding == null) {
                this.warning("NoMatchingCallbackBinding", endpoint.getSourceComponentReference(), endpoint.getSourceComponentReference().getName(), endpoint.getTargetComponentService().getName());
            } else {
                endpoint.setSourceCallbackBinding(resolvedCallbackBinding);
            }
        }
    }
}

