/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.builder.AutomaticBinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeReferenceConfigurationBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public CompositeReferenceConfigurationBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    @Override
    public void build(Composite composite) throws CompositeBuilderException {
        this.configureNestedCompositeReferences(composite);
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            List<ComponentReference> promotedRefs = compositeReference.getPromotedReferences();
            if (promotedRefs.isEmpty()) continue;
            if (promotedRefs.size() == 1) {
                ComponentReference promotedReference = promotedRefs.get(0);
                if (this.bindingsSpecifiedManually(compositeReference.getBindings())) {
                    compositeReference.setPromotionOverride(true);
                } else if (this.bindingsSpecifiedManually(promotedReference.getBindings())) {
                    compositeReference.getBindings().clear();
                    for (Binding binding : promotedReference.getBindings()) {
                        try {
                            compositeReference.getBindings().add((Binding)binding.clone());
                        }
                        catch (CloneNotSupportedException ex) {}
                    }
                }
                if (compositeReference.getInterfaceContract() == null || compositeReference.getInterfaceContract().getCallbackInterface() == null) continue;
                if (compositeReference.getCallback() != null && this.bindingsSpecifiedManually(compositeReference.getCallback().getBindings())) {
                    compositeReference.setPromotionOverride(true);
                    continue;
                }
                if (promotedReference.getCallback() == null || !this.bindingsSpecifiedManually(promotedReference.getCallback().getBindings())) continue;
                if (compositeReference.getCallback() != null) {
                    compositeReference.getCallback().getBindings().clear();
                } else {
                    compositeReference.setCallback(this.assemblyFactory.createCallback());
                }
                for (Binding binding : promotedReference.getCallback().getBindings()) {
                    try {
                        compositeReference.getCallback().getBindings().add((Binding)binding.clone());
                    }
                    catch (CloneNotSupportedException ex) {}
                }
                continue;
            }
            if (!this.bindingsSpecifiedManually(compositeReference.getBindings()) && (compositeReference.getCallback() == null || !this.bindingsSpecifiedManually(compositeReference.getCallback().getBindings()))) continue;
            compositeReference.setPromotionOverride(true);
        }
    }

    private void configureNestedCompositeReferences(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureNestedCompositeReferences((Composite)implementation);
            for (ComponentReference componentReference : component.getReferences()) {
                CompositeReference compositeReference;
                List<ComponentReference> promotedRefs;
                Reference implReference = componentReference.getReference();
                if (implReference == null || !(implReference instanceof CompositeReference) || (promotedRefs = (compositeReference = (CompositeReference)implReference).getPromotedReferences()).isEmpty()) continue;
                if (promotedRefs.size() == 1) {
                    ComponentReference promotedReference = promotedRefs.get(0);
                    if (!this.bindingsSpecifiedManually(compositeReference.getBindings()) && this.bindingsSpecifiedManually(promotedReference.getBindings())) {
                        compositeReference.getBindings().clear();
                        for (Binding binding : promotedReference.getBindings()) {
                            try {
                                compositeReference.getBindings().add((Binding)binding.clone());
                            }
                            catch (CloneNotSupportedException ex) {}
                        }
                    }
                    if (this.bindingsSpecifiedManually(componentReference.getBindings())) {
                        componentReference.setPromotionOverride(true);
                    } else if (this.bindingsSpecifiedManually(compositeReference.getBindings())) {
                        componentReference.getBindings().clear();
                        componentReference.getBindings().addAll(compositeReference.getBindings());
                    }
                    if (componentReference.getInterfaceContract() == null || componentReference.getInterfaceContract().getCallbackInterface() == null) continue;
                    if ((compositeReference.getCallback() == null || !this.bindingsSpecifiedManually(compositeReference.getCallback().getBindings())) && promotedReference.getCallback() != null && this.bindingsSpecifiedManually(promotedReference.getCallback().getBindings())) {
                        if (compositeReference.getCallback() != null) {
                            compositeReference.getCallback().getBindings().clear();
                        } else {
                            compositeReference.setCallback(this.assemblyFactory.createCallback());
                        }
                        compositeReference.getCallback().getBindings().addAll(promotedReference.getCallback().getBindings());
                    }
                    if (componentReference.getCallback() != null && this.bindingsSpecifiedManually(componentReference.getCallback().getBindings())) {
                        componentReference.setPromotionOverride(true);
                        continue;
                    }
                    if (compositeReference.getCallback() == null || !this.bindingsSpecifiedManually(compositeReference.getCallback().getBindings())) continue;
                    if (componentReference.getCallback() != null) {
                        componentReference.getCallback().getBindings().clear();
                    } else {
                        componentReference.setCallback(this.assemblyFactory.createCallback());
                    }
                    for (Binding binding : compositeReference.getCallback().getBindings()) {
                        try {
                            componentReference.getCallback().getBindings().add((Binding)binding.clone());
                        }
                        catch (CloneNotSupportedException ex) {}
                    }
                    continue;
                }
                if (!this.bindingsSpecifiedManually(componentReference.getBindings()) && (componentReference.getCallback() == null || !this.bindingsSpecifiedManually(componentReference.getCallback().getBindings()))) continue;
                componentReference.setPromotionOverride(true);
            }
        }
    }

    private boolean bindingsSpecifiedManually(List<Binding> bindings) {
        if (bindings.size() > 1) {
            return true;
        }
        if (bindings.size() == 1 && bindings.get(0) instanceof AutomaticBinding && ((AutomaticBinding)((Object)bindings.get(0))).getIsAutomatic()) {
            return false;
        }
        return bindings.size() == 1;
    }
}

