/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIncludeBuilderImpl
implements CompositeBuilder {
    private Monitor monitor;

    public CompositeIncludeBuilderImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void build(Composite composite) throws CompositeBuilderException {
        this.fuseIncludes(composite);
    }

    private void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void collectIncludes(Composite composite, List<Composite> includes, Set<Composite> visited) {
        for (Composite include : composite.getIncludes()) {
            if (visited.contains(include)) {
                this.warning("CompositeAlreadyIncluded", composite, include.getName().toString());
                continue;
            }
            includes.add(include);
            visited.add(include);
            this.collectIncludes(include, includes, visited);
        }
    }

    private void fuseIncludes(Composite composite) {
        ArrayList<Composite> includes = new ArrayList<Composite>();
        HashSet<Composite> visited = new HashSet<Composite>();
        visited.add(composite);
        this.collectIncludes(composite, includes, visited);
        for (Composite include : includes) {
            Composite clone;
            try {
                clone = (Composite)include.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            composite.getComponents().addAll(clone.getComponents());
            composite.getServices().addAll(clone.getServices());
            composite.getReferences().addAll(clone.getReferences());
            composite.getProperties().addAll(clone.getProperties());
            composite.getWires().addAll(clone.getWires());
            composite.getPolicySets().addAll(clone.getPolicySets());
            composite.getRequiredIntents().addAll(clone.getRequiredIntents());
        }
        composite.getIncludes().clear();
    }
}

