/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;

public class ComponentServicePromotionBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public ComponentServicePromotionBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    public void build(Composite composite) throws CompositeBuilderException {
        this.configureNestedCompositeServices(composite);
    }

    private void configureNestedCompositeServices(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureNestedCompositeServices((Composite)implementation);
            for (ComponentService componentService : component.getServices()) {
                CompositeService compositeService;
                ComponentService promotedService;
                Service implService = componentService.getService();
                if (implService == null || !(implService instanceof CompositeService) || (promotedService = ServiceConfigurationUtil.getPromotedComponentService(compositeService = (CompositeService)implService)) == null) continue;
                Component promotedComponent = ServiceConfigurationUtil.getPromotedComponent(compositeService);
                ComponentService newComponentService = this.assemblyFactory.createComponentService();
                newComponentService.setName("$promoted$" + component.getName() + "$slash$" + componentService.getName());
                promotedComponent.getServices().add(newComponentService);
                newComponentService.setService(promotedService.getService());
                newComponentService.getBindings().addAll(componentService.getBindings());
                newComponentService.setInterfaceContract(componentService.getInterfaceContract());
                if (componentService.getInterfaceContract() != null && componentService.getInterfaceContract().getCallbackInterface() != null) {
                    newComponentService.setCallback(this.assemblyFactory.createCallback());
                    newComponentService.getCallback().getBindings().addAll(componentService.getCallback().getBindings());
                }
                compositeService.setPromotedComponent(promotedComponent);
                compositeService.setPromotedService(newComponentService);
            }
        }
    }
}

