/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.AutomaticBinding;
import org.apache.tuscany.sca.assembly.builder.ComponentPreProcessor;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.builder.impl.PropertyConfigurationUtil;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.IntentAttachPointType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConfigurationBuilderImpl {
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";
    private static final String BINDING_SCA = "binding.sca";
    private static final QName BINDING_SCA_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "binding.sca");
    private AssemblyFactory assemblyFactory;
    private SCABindingFactory scaBindingFactory;
    private Monitor monitor;
    private InterfaceContractMapper interfaceContractMapper;
    private SCADefinitions policyDefinitions;
    private DocumentBuilderFactory documentBuilderFactory;
    private TransformerFactory transformerFactory;

    protected BaseConfigurationBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, InterfaceContractMapper interfaceContractMapper, SCADefinitions policyDefinitions, Monitor monitor) {
        this.assemblyFactory = assemblyFactory;
        this.scaBindingFactory = scaBindingFactory;
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
        this.interfaceContractMapper = interfaceContractMapper;
        this.policyDefinitions = policyDefinitions;
        this.monitor = monitor;
    }

    protected void configureComponents(Composite composite) throws CompositeBuilderException {
        this.configureComponents(composite, null);
        this.configureSourcedProperties(composite, null);
    }

    private void configureComponents(Composite composite, String uri) {
        SCABinding scaBinding;
        String parentURI = uri;
        for (Component component : composite.getComponents()) {
            String componentURI = parentURI == null ? component.getName() : URI.create(parentURI + '/').resolve(component.getName()).toString();
            component.setURI(componentURI);
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureComponents((Composite)implementation, componentURI);
        }
        List<Service> compositeServices = composite.getServices();
        for (Service service : compositeServices) {
            if (!service.getBindings().isEmpty()) continue;
            scaBinding = this.createSCABinding();
            service.getBindings().add(scaBinding);
        }
        for (Reference reference : composite.getReferences()) {
            if (!reference.getBindings().isEmpty()) continue;
            scaBinding = this.createSCABinding();
            reference.getBindings().add(scaBinding);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        for (Component component : composite.getComponents()) {
            SCABinding scaBinding2;
            if (components.containsKey(component.getName())) {
                this.error("DuplicateComponentName", component, composite.getName().toString(), component.getName());
            } else {
                components.put(component.getName(), component);
            }
            if (component.getAutowire() == null) {
                component.setAutowire(composite.getAutowire());
            }
            if (component.getImplementation() instanceof ComponentPreProcessor) {
                ((ComponentPreProcessor)((Object)component.getImplementation())).preProcess(component);
            }
            HashMap<String, Service> services = new HashMap<String, Service>();
            HashMap<String, Reference> references = new HashMap<String, Reference>();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            this.indexImplementationPropertiesServicesAndReferences(component, services, references, properties);
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            HashMap<String, ComponentProperty> componentProperties = new HashMap<String, ComponentProperty>();
            this.indexComponentPropertiesServicesAndReferences(component, componentServices, componentReferences, componentProperties);
            this.reconcileServices(component, services, componentServices);
            this.reconcileReferences(component, references, componentReferences);
            this.reconcileProperties(component, properties, componentProperties);
            this.configureCallbackServices(component, componentServices);
            this.configureCallbackReferences(component, componentReferences);
            for (ComponentService componentService : component.getServices()) {
                if (!componentService.getBindings().isEmpty()) continue;
                scaBinding2 = this.createSCABinding();
                componentService.getBindings().add(scaBinding2);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                if (!componentReference.getBindings().isEmpty()) continue;
                scaBinding2 = this.createSCABinding();
                componentReference.getBindings().add(scaBinding2);
            }
        }
    }

    private void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    private void reconcileProperties(Component component, Map<String, Property> properties, Map<String, ComponentProperty> componentProperties) {
        Property property;
        for (ComponentProperty componentProperty : component.getProperties()) {
            property = properties.get(componentProperty.getName());
            if (property != null) {
                componentProperty.setProperty(property);
                continue;
            }
            this.warning("PropertyNotFound", component, component.getName(), componentProperty.getName());
        }
        if (component.getImplementation() != null) {
            for (Property property2 : component.getImplementation().getProperties()) {
                if (componentProperties.containsKey(property2.getName())) continue;
                ComponentProperty componentProperty = this.assemblyFactory.createComponentProperty();
                componentProperty.setName(property2.getName());
                componentProperty.setMany(property2.isMany());
                componentProperty.setXSDElement(property2.getXSDElement());
                componentProperty.setXSDType(property2.getXSDType());
                componentProperty.setProperty(property2);
                component.getProperties().add(componentProperty);
            }
        }
        for (ComponentProperty componentProperty : component.getProperties()) {
            property = componentProperty.getProperty();
            if (property == null) continue;
            if (!property.isMustSupply() && componentProperty.isMustSupply()) {
                this.warning("PropertyMustSupplyIncompatible", component, component.getName(), componentProperty.getName());
            }
            if (!componentProperty.isMustSupply()) {
                componentProperty.setMustSupply(property.isMustSupply());
            }
            if (componentProperty.getValue() == null) {
                componentProperty.setValue(property.getValue());
            }
            if (component.getImplementation() instanceof Composite) {
                property.setValue(componentProperty.getValue());
            }
            if (componentProperty.getValue() == null && property.isMustSupply()) {
                this.warning("PropertyMustSupplyNull", component, component.getName(), componentProperty.getName());
            }
            if (!property.isMany() && componentProperty.isMany()) {
                this.warning("PropertyOverrideManyAttribute", component, component.getName(), componentProperty.getName());
            }
            componentProperty.setMany(property.isMany());
            if (componentProperty.getXSDType() == null) {
                componentProperty.setXSDType(property.getXSDType());
            }
            if (componentProperty.getXSDElement() == null) {
                componentProperty.setXSDElement(property.getXSDElement());
            }
            if (componentProperty.getXSDElement() != null || componentProperty.getXSDType() != null) continue;
            this.warning("NoTypeForComponentProperty", component, component.getName(), componentProperty.getName());
        }
    }

    private void reconcileReferences(Component component, Map<String, Reference> references, Map<String, ComponentReference> componentReferences) {
        Reference reference;
        for (ComponentReference componentReference : component.getReferences()) {
            if (componentReference.getReference() != null || componentReference.isCallback()) continue;
            reference = references.get(componentReference.getName());
            if (reference != null) {
                componentReference.setReference(reference);
                continue;
            }
            if (componentReference.getName().startsWith("$self$.")) continue;
            this.error("ReferenceNotFound", component, component.getName(), componentReference.getName());
        }
        if (component.getImplementation() != null) {
            for (Reference reference2 : component.getImplementation().getReferences()) {
                if (componentReferences.containsKey(reference2.getName())) continue;
                ComponentReference componentReference = this.assemblyFactory.createComponentReference();
                componentReference.setIsCallback(reference2.isCallback());
                componentReference.setName(reference2.getName());
                componentReference.setReference(reference2);
                component.getReferences().add(componentReference);
            }
        }
        for (ComponentReference componentReference : component.getReferences()) {
            reference = componentReference.getReference();
            if (reference == null) continue;
            if (componentReference.getMultiplicity() != null) {
                if (!ReferenceConfigurationUtil.isValidMultiplicityOverride(reference.getMultiplicity(), componentReference.getMultiplicity())) {
                    this.warning("ReferenceIncompatibleMultiplicity", component, component.getName(), componentReference.getName());
                }
            } else {
                componentReference.setMultiplicity(reference.getMultiplicity());
            }
            InterfaceContract interfaceContract = reference.getInterfaceContract();
            if (componentReference.getInterfaceContract() != null) {
                if (interfaceContract != null && !componentReference.getInterfaceContract().equals(reference.getInterfaceContract()) && !this.interfaceContractMapper.isCompatible(componentReference.getInterfaceContract(), interfaceContract)) {
                    this.warning("ReferenceIncompatibleComponentInterface", component, component.getName(), componentReference.getName());
                }
            } else {
                componentReference.setInterfaceContract(interfaceContract);
            }
            if (componentReference.getBindings().isEmpty()) {
                componentReference.getBindings().addAll(reference.getBindings());
            }
            if (componentReference.getCallback() == null) {
                componentReference.setCallback(reference.getCallback());
                if (componentReference.getCallback() == null) {
                    componentReference.setCallback(this.assemblyFactory.createCallback());
                }
            } else if (componentReference.getCallback().getBindings().isEmpty() && reference.getCallback() != null) {
                componentReference.getCallback().getBindings().addAll(reference.getCallback().getBindings());
            }
            if (componentReference.getAutowire() == null) {
                componentReference.setAutowire(component.getAutowire());
            }
            if (!componentReference.getTargets().isEmpty()) continue;
            componentReference.getTargets().addAll(reference.getTargets());
        }
    }

    private void reconcileServices(Component component, Map<String, Service> services, Map<String, ComponentService> componentServices) {
        Service service;
        for (ComponentService componentService : component.getServices()) {
            if (componentService.getService() != null || componentService.isCallback()) continue;
            service = services.get(componentService.getName());
            if (service != null) {
                componentService.setService(service);
                continue;
            }
            this.warning("ServiceNotFoundForComponentService", component, component.getName(), componentService.getName());
        }
        if (component.getImplementation() != null) {
            for (Service service2 : component.getImplementation().getServices()) {
                if (componentServices.containsKey(service2.getName())) continue;
                ComponentService componentService = this.assemblyFactory.createComponentService();
                componentService.setIsCallback(service2.isCallback());
                String name = service2.getName();
                componentService.setName(name);
                componentService.setService(service2);
                component.getServices().add(componentService);
                componentServices.put(name, componentService);
            }
        }
        for (ComponentService componentService : component.getServices()) {
            service = componentService.getService();
            if (service == null) continue;
            InterfaceContract interfaceContract = service.getInterfaceContract();
            if (componentService.getInterfaceContract() != null) {
                if (interfaceContract != null && !componentService.getInterfaceContract().equals(interfaceContract) && !this.interfaceContractMapper.isCompatible(componentService.getInterfaceContract(), interfaceContract)) {
                    this.warning("ServiceIncompatibleComponentInterface", component, component.getName(), componentService.getName());
                }
            } else {
                componentService.setInterfaceContract(interfaceContract);
            }
            if (componentService.getBindings().isEmpty()) {
                componentService.getBindings().addAll(service.getBindings());
            }
            if (componentService.getCallback() == null) {
                componentService.setCallback(service.getCallback());
                if (componentService.getCallback() != null) continue;
                componentService.setCallback(this.assemblyFactory.createCallback());
                continue;
            }
            if (!componentService.getCallback().getBindings().isEmpty() || service.getCallback() == null) continue;
            componentService.getCallback().getBindings().addAll(service.getCallback().getBindings());
        }
    }

    private void indexComponentPropertiesServicesAndReferences(Component component, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences, Map<String, ComponentProperty> componentProperties) {
        for (ComponentService componentService : component.getServices()) {
            if (componentServices.containsKey(componentService.getName())) {
                this.warning("DuplicateComponentServiceName", component, component.getName(), componentService.getName());
                continue;
            }
            componentServices.put(componentService.getName(), componentService);
        }
        for (ComponentReference componentReference : component.getReferences()) {
            if (componentReferences.containsKey(componentReference.getName())) {
                this.warning("DuplicateComponentReferenceName", component, component.getName(), componentReference.getName());
                continue;
            }
            componentReferences.put(componentReference.getName(), componentReference);
        }
        for (ComponentProperty componentProperty : component.getProperties()) {
            if (componentProperties.containsKey(componentProperty.getName())) {
                this.warning("DuplicateComponentPropertyName", component, component.getName(), componentProperty.getName());
                continue;
            }
            componentProperties.put(componentProperty.getName(), componentProperty);
        }
    }

    private void indexImplementationPropertiesServicesAndReferences(Component component, Map<String, Service> services, Map<String, Reference> references, Map<String, Property> properties) {
        Implementation implementation = component.getImplementation();
        if (implementation == null) {
            this.warning("NoComponentImplementation", component, component.getName());
        } else if (implementation.isUnresolved()) {
            this.warning("UnresolvedComponentImplementation", component, component.getName(), implementation.getURI());
        } else {
            for (Property property : implementation.getProperties()) {
                if (properties.containsKey(property.getName())) {
                    this.warning("DuplicateImplementationPropertyName", component, component.getName(), property.getName());
                    continue;
                }
                properties.put(property.getName(), property);
            }
            for (Service service : implementation.getServices()) {
                if (services.containsKey(service.getName())) {
                    this.warning("DuplicateImplementationServiceName", component, component.getName(), service.getName());
                    continue;
                }
                services.put(service.getName(), service);
            }
            for (Reference reference : implementation.getReferences()) {
                if (references.containsKey(reference.getName())) {
                    this.warning("DuplicateImplementationReferenceName", component, component.getName(), reference.getName());
                    continue;
                }
                references.put(reference.getName(), reference);
            }
        }
    }

    private void configureCallbackServices(Component component, Map<String, ComponentService> componentServices) {
        for (ComponentReference reference : component.getReferences()) {
            if (reference.getInterfaceContract() == null || reference.getInterfaceContract().getCallbackInterface() == null) continue;
            ComponentService service = componentServices.get(reference.getName());
            if (service == null) {
                service = this.createCallbackService(component, reference);
            }
            if (reference.getCallback() != null && service.getBindings().isEmpty()) {
                service.getBindings().addAll(reference.getCallback().getBindings());
            }
            reference.setCallbackService(service);
        }
    }

    private ComponentService createCallbackService(Component component, ComponentReference reference) {
        ComponentService componentService = this.assemblyFactory.createComponentService();
        componentService.setIsCallback(true);
        componentService.setName(reference.getName());
        try {
            InterfaceContract contract = (InterfaceContract)reference.getInterfaceContract().clone();
            contract.setInterface(contract.getCallbackInterface());
            contract.setCallbackInterface(null);
            componentService.setInterfaceContract(contract);
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        Reference implReference = reference.getReference();
        if (implReference != null) {
            Service implService = this.assemblyFactory.createService();
            implService.setName(implReference.getName());
            try {
                InterfaceContract implContract = (InterfaceContract)implReference.getInterfaceContract().clone();
                implContract.setInterface(implContract.getCallbackInterface());
                implContract.setCallbackInterface(null);
                implService.setInterfaceContract(implContract);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            componentService.setService(implService);
        }
        component.getServices().add(componentService);
        return componentService;
    }

    private void configureCallbackReferences(Component component, Map<String, ComponentReference> componentReferences) {
        for (ComponentService service : component.getServices()) {
            if (service.getInterfaceContract() == null || service.getInterfaceContract().getCallbackInterface() == null) continue;
            ComponentReference reference = componentReferences.get(service.getName());
            if (reference == null) {
                reference = this.createCallbackReference(component, service);
            }
            if (service.getCallback() != null && reference.getBindings().isEmpty()) {
                reference.getBindings().addAll(service.getCallback().getBindings());
            }
            service.setCallbackReference(reference);
        }
    }

    private ComponentReference createCallbackReference(Component component, ComponentService service) {
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setIsCallback(true);
        componentReference.setName(service.getName());
        try {
            InterfaceContract contract = (InterfaceContract)service.getInterfaceContract().clone();
            contract.setInterface(contract.getCallbackInterface());
            contract.setCallbackInterface(null);
            componentReference.setInterfaceContract(contract);
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        Service implService = service.getService();
        if (implService != null) {
            Reference implReference = this.assemblyFactory.createReference();
            implReference.setName(implService.getName());
            try {
                InterfaceContract implContract = (InterfaceContract)implService.getInterfaceContract().clone();
                implContract.setInterface(implContract.getCallbackInterface());
                implContract.setCallbackInterface(null);
                implReference.setInterfaceContract(implContract);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            componentReference.setReference(implReference);
        }
        component.getReferences().add(componentReference);
        return componentReference;
    }

    private void configureSourcedProperties(Composite composite, List<ComponentProperty> propertySettings) {
        HashMap<String, Property> compositeProperties = new HashMap<String, Property>();
        ComponentProperty componentProperty = null;
        for (Property p : composite.getProperties()) {
            componentProperty = this.getComponentPropertyByName(p.getName(), propertySettings);
            if (componentProperty != null) {
                compositeProperties.put(p.getName(), componentProperty);
                continue;
            }
            compositeProperties.put(p.getName(), p);
        }
        for (Component component : composite.getComponents()) {
            Implementation impl;
            try {
                PropertyConfigurationUtil.sourceComponentProperties(compositeProperties, component, this.documentBuilderFactory, this.transformerFactory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!((impl = component.getImplementation()) instanceof Composite)) continue;
            this.configureSourcedProperties((Composite)impl, component.getProperties());
        }
    }

    private ComponentProperty getComponentPropertyByName(String propertyName, List<ComponentProperty> properties) {
        if (properties != null) {
            for (ComponentProperty aProperty : properties) {
                if (!aProperty.getName().equals(propertyName)) continue;
                return aProperty;
            }
        }
        return null;
    }

    private SCABinding createSCABinding() {
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        if (scaBinding instanceof AutomaticBinding) {
            ((AutomaticBinding)((Object)scaBinding)).setIsAutomatic(true);
        }
        if (this.policyDefinitions != null) {
            for (IntentAttachPointType attachPointType : this.policyDefinitions.getBindingTypes()) {
                if (!attachPointType.getName().equals(BINDING_SCA_QNAME)) continue;
                ((IntentAttachPoint)((Object)scaBinding)).setType(attachPointType);
            }
        }
        return scaBinding;
    }

    protected void configureBindingURIsAndNames(Composite composite) throws CompositeBuilderException {
        this.configureBindingURIs(composite, null, null);
        this.configureBindingNames(composite);
    }

    protected void configureBindingURIs(Composite composite, List<Binding> defaultBindings) throws CompositeBuilderException {
        this.configureBindingURIs(composite, null, defaultBindings);
    }

    private void configureBindingURIs(Composite composite, String uri, List<Binding> defaultBindings) throws CompositeBuilderException {
        String parentComponentURI = uri;
        for (Component component : composite.getComponents()) {
            String componentURI = parentComponentURI == null ? component.getName() : URI.create(parentComponentURI + '/').resolve(component.getName()).toString();
            component.setURI(componentURI);
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureBindingURIs((Composite)implementation, componentURI, defaultBindings);
        }
        List<Service> compositeServices = composite.getServices();
        for (Service service : compositeServices) {
            if (service.getBindings().isEmpty()) {
                SCABinding scaBinding = this.createSCABinding();
                service.getBindings().add(scaBinding);
            }
            for (Binding binding : service.getBindings()) {
                this.constructBindingName(service, binding);
                this.constructBindingURI(parentComponentURI, composite, service, binding, defaultBindings);
            }
        }
        for (Component component : composite.getComponents()) {
            HashMap<String, Service> services = new HashMap<String, Service>();
            HashMap<String, Reference> references = new HashMap<String, Reference>();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            this.indexImplementationPropertiesServicesAndReferences(component, services, references, properties);
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            HashMap<String, ComponentProperty> componentProperties = new HashMap<String, ComponentProperty>();
            this.indexComponentPropertiesServicesAndReferences(component, componentServices, componentReferences, componentProperties);
            this.reconcileServices(component, services, componentServices);
            this.reconcileReferences(component, references, componentReferences);
            this.reconcileProperties(component, properties, componentProperties);
            for (ComponentService service : component.getServices()) {
                if (service.getBindings().isEmpty()) {
                    SCABinding scaBinding = this.createSCABinding();
                    service.getBindings().add(scaBinding);
                }
                for (Binding binding : service.getBindings()) {
                    this.constructBindingName(service, binding);
                    this.constructBindingURI(component, service, binding, defaultBindings);
                }
            }
        }
    }

    private void configureBindingNames(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureBindingNames((Composite)implementation);
        }
        for (Service service : composite.getServices()) {
            if (service.getCallback() == null) continue;
            for (Binding binding : service.getCallback().getBindings()) {
                this.constructBindingName(service, binding);
            }
        }
        for (Reference reference : composite.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                this.constructBindingName(reference, binding);
            }
            if (reference.getCallback() == null) continue;
            for (Binding binding : reference.getCallback().getBindings()) {
                this.constructBindingName(reference, binding);
            }
        }
        for (Component component : composite.getComponents()) {
            for (ComponentService service : component.getServices()) {
                if (service.getCallback() == null) continue;
                for (Binding binding : service.getCallback().getBindings()) {
                    this.constructBindingName(service, binding);
                }
            }
            for (ComponentReference reference : component.getReferences()) {
                for (Binding binding : reference.getBindings()) {
                    this.constructBindingName(reference, binding);
                }
                if (reference.getCallback() == null) continue;
                for (Binding binding : reference.getCallback().getBindings()) {
                    this.constructBindingName(reference, binding);
                }
            }
        }
    }

    private void constructBindingName(Contract contract, Binding binding) {
        if (binding == null) {
            this.warning("Binding is null", binding, contract.getName());
            return;
        }
        if (binding.getName() == null) {
            binding.setName(contract.getName());
        }
        for (Binding otherBinding : contract.getBindings()) {
            if (otherBinding == binding || binding.getClass() != otherBinding.getClass() || !binding.getName().equals(otherBinding.getName())) continue;
            this.warning(contract instanceof Service ? "MultipleBindingsForService" : "MultipleBindingsForReference", binding, contract.getName(), binding.getName());
        }
    }

    private void constructBindingURI(String parentComponentURI, Composite composite, Service service, Binding binding, List<Binding> defaultBindings) throws CompositeBuilderException {
        boolean includeBindingName = composite.getServices().size() != 1;
        this.constructBindingURI(parentComponentURI, service, binding, includeBindingName, defaultBindings);
    }

    private void constructBindingURI(Component component, Service service, Binding binding, List<Binding> defaultBindings) throws CompositeBuilderException {
        boolean includeBindingName = component.getServices().size() != 1;
        this.constructBindingURI(component.getURI(), service, binding, includeBindingName, defaultBindings);
    }

    private void constructBindingURI(String componentURIString, Service service, Binding binding, boolean includeBindingName, List<Binding> defaultBindings) throws CompositeBuilderException {
        try {
            URI bindingURI;
            if (binding.getURI() != null) {
                bindingURI = new URI(binding.getURI());
                if (bindingURI.isAbsolute()) {
                    binding.setURI(bindingURI.toString());
                    return;
                }
            } else {
                bindingURI = null;
            }
            URI bindingName = binding.getName() != null ? new URI(binding.getName()) : new URI("");
            URI componentURI = componentURIString != null ? new URI(BaseConfigurationBuilderImpl.addSlashToPath(componentURIString)) : null;
            if (componentURI != null && componentURI.isAbsolute()) {
                binding.setURI(BaseConfigurationBuilderImpl.constructBindingURI(null, componentURI, bindingURI, includeBindingName, bindingName));
                return;
            }
            URI baseURI = null;
            if (defaultBindings != null) {
                for (Binding defaultBinding : defaultBindings) {
                    if (binding.getClass() != defaultBinding.getClass()) continue;
                    baseURI = new URI(BaseConfigurationBuilderImpl.addSlashToPath(defaultBinding.getURI()));
                    break;
                }
            }
            binding.setURI(BaseConfigurationBuilderImpl.constructBindingURI(baseURI, componentURI, bindingURI, includeBindingName, bindingName));
        }
        catch (URISyntaxException ex) {
            this.error("URLSyntaxException", binding, componentURIString, service.getName(), binding.getName());
        }
    }

    private static String addSlashToPath(String path) {
        if (path.endsWith("/") || path.endsWith("#")) {
            return path;
        }
        return path + "/";
    }

    private static String constructBindingURI(URI baseURI, URI componentURI, URI bindingURI, boolean includeBindingName, URI bindingName) {
        URI uri;
        String uriString = baseURI == null ? (componentURI == null ? (bindingURI != null ? bindingURI.toString() : bindingName.toString()) : (bindingURI != null ? componentURI.resolve(bindingURI).toString() : (includeBindingName ? componentURI.resolve(bindingName).toString() : componentURI.toString()))) : (componentURI == null ? (bindingURI != null ? BaseConfigurationBuilderImpl.basedURI(baseURI, bindingURI).toString() : (includeBindingName ? BaseConfigurationBuilderImpl.basedURI(baseURI, bindingName).toString() : baseURI.toString())) : (bindingURI != null ? BaseConfigurationBuilderImpl.basedURI(baseURI, componentURI.resolve(bindingURI)).toString() : (includeBindingName ? BaseConfigurationBuilderImpl.basedURI(baseURI, componentURI.resolve(bindingName)).toString() : BaseConfigurationBuilderImpl.basedURI(baseURI, componentURI).toString())));
        if (uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (!(uri = URI.create(uriString)).isAbsolute()) {
            uri = URI.create("/").resolve(uri);
        }
        return uri.toString();
    }

    private static URI basedURI(URI baseURI, URI uri) {
        if (uri.getScheme() != null) {
            return uri;
        }
        String str = uri.toString();
        if (str.startsWith("/")) {
            str = str.substring(1);
        }
        return URI.create(baseURI.toString() + str).normalize();
    }
}

