/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.aspectj;

import org.apache.tuscany.sca.aspectj.TracingAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class SimpleTracingAspect
extends TracingAspect {
    @Pointcut(value="execution(public * org.apache.tuscany.sca..*.*(..))")
    protected void entry() {
    }

    @Pointcut(value="within(org.apache.tuscany.sca..*) && !within(org.apache.tuscany.sca.aspectj..*Aspect)")
    protected void withinScope() {
    }

    protected void startLog() {
        System.out.println(">>> ----------------------------------------------------");
    }

    protected void completeLog() {
        System.out.println("<<< ----------------------------------------------------");
    }

    protected void logEnter(JoinPoint jp) {
        System.out.println("> logEnter jp.getSignature=" + jp.getSignature());
        Object[] args = jp.getArgs();
        if (args != null && args.length > 0) {
            System.out.print("  logEnter jp.getArgs(" + args.length + ")=[");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    System.out.print(",");
                }
                System.out.print(args[i]);
            }
            System.out.println("]");
        }
    }

    protected void logExit(JoinPoint jp, Object result) {
        System.out.println("< logExit jp.getSignature=" + jp.getSignature() + ", result=" + result);
    }

    protected void logThrowable(JoinPoint jp, Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        System.out.println("! logThrowable jp.getSignature=" + jp.getSignature() + ", throwable=" + throwable);
    }
}

