/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.aspectj;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class LoggingAspect {
    @Pointcut(value="call(* org.apache.tuscany.sca..*(..)) && (!within(org.apache.tuscany.sca.aspectj.*Aspect))")
    public void anyMethodCall() {
    }

    @Pointcut(value="execution(* org.apache.tuscany.sca..*(..)) && (!within(org.apache.tuscany.sca.aspectj.*Aspect))")
    public void anyMethodExecution() {
    }

    @Pointcut(value="call(* java.util.logging.Logger.info(..))")
    public void anyLogCall() {
    }

    @Pointcut(value="cflow(anyMethodExecution()) && anyLogCall()")
    public void anyLog() {
    }

    @Pointcut(value="call(org.apache.tuscany.sca..*.new(..))")
    public void anyConstructor() {
    }

    @Pointcut(value="staticinitialization(org.apache.tuscany.sca.implementation..*)")
    public void anyStatic() {
    }

    @Before(value="anyMethodCall()")
    public void before(JoinPoint jp) {
        System.out.println("Logging Before anyMethodCall jp.getSignature=" + jp.getSignature());
        Object[] args = jp.getArgs();
        if (args != null && args.length > 0) {
            System.out.println("Logging Before anyMethodCall jp.getArgs=" + Arrays.asList(args));
        }
    }

    @AfterReturning(pointcut="anyMethodCall()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        System.out.println("Logging AfterReturning anyMethodCall jp=" + jp + ", result=" + result);
    }

    @AfterThrowing(pointcut="anyMethodCall()", throwing="t")
    public void afterThrowing(JoinPoint jp, Throwable t) {
        System.out.println("Logging AfterThrowing anyMethodCall jp=" + jp + ", t=" + t);
    }

    @Before(value="anyConstructor()")
    public void beforeConstructor(JoinPoint jp) {
        System.out.println("Logging Before anyConstructor jp.getSignature=" + jp.getSignature());
        Object[] args = jp.getArgs();
        if (args != null && args.length > 0) {
            System.out.println("Logging Before anyConstructor jp.getArgs=" + Arrays.asList(args));
        }
    }

    @Before(value="anyStatic()")
    public void beforeStatic(JoinPoint jp) {
        System.out.println("Logging Before anyStatic before jp=" + jp);
        System.out.println("Logging anyMethodCall before jp.getSourceLocation=" + jp.getSourceLocation());
    }
}

