/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyValidationUtils {
    public static boolean isConstrained(QName constrained, IntentAttachPointType attachPointType) {
        return attachPointType != null && attachPointType.getName().getNamespaceURI().equals(constrained.getNamespaceURI()) && attachPointType.getName().getLocalPart().startsWith(constrained.getLocalPart());
    }

    public static void validateIntents(IntentAttachPoint attachPoint, IntentAttachPointType attachPointType) throws PolicyValidationException {
        boolean found = false;
        if (attachPointType != null) {
            found = false;
            for (Intent intent : attachPoint.getRequiredIntents()) {
                if (!intent.isUnresolved()) {
                    for (QName constrained : intent.getConstrains()) {
                        if (!PolicyValidationUtils.isConstrained(constrained, attachPointType)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new PolicyValidationException("Policy Intent '" + intent.getName() + "' does not constrain extension type  " + attachPointType.getName());
                }
                throw new PolicyValidationException("Policy Intent '" + intent.getName() + "' is not defined in this domain  ");
            }
        }
    }

    public static void validatePolicySets(PolicySetAttachPoint policySetAttachPoint) throws PolicyValidationException {
        PolicyValidationUtils.validatePolicySets(policySetAttachPoint, policySetAttachPoint.getType(), policySetAttachPoint.getApplicablePolicySets());
    }

    public static void validatePolicySets(PolicySetAttachPoint policySetAttachPoint, IntentAttachPointType attachPointType) throws PolicyValidationException {
        PolicyValidationUtils.validatePolicySets(policySetAttachPoint, attachPointType, policySetAttachPoint.getApplicablePolicySets());
    }

    public static void validatePolicySets(PolicySetAttachPoint policySetAttachPoint, IntentAttachPointType attachPointType, List<PolicySet> applicablePolicySets) throws PolicyValidationException {
        for (PolicySet definedPolicySet : policySetAttachPoint.getPolicySets()) {
            if (!definedPolicySet.isUnresolved()) {
                if (applicablePolicySets.contains(definedPolicySet)) continue;
                throw new PolicyValidationException("Policy Set '" + definedPolicySet.getName() + "' does not apply to extension type  " + attachPointType.getName());
            }
            throw new PolicyValidationException("Policy Set '" + definedPolicySet.getName() + "' is not defined in this domain  ");
        }
    }
}

