/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.ProfileIntent;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyComputationUtils {
    private static final String POLICYSET_PREFIX = "tp_";
    private static final String APPLICABLE_POLICYSET_ATTR_NS = "http://tuscany.apache.org/xmlns/sca/1.0";
    private static final String APPLICABLE_POLICYSET_ATTR = "applicablePolicySets";
    private static final String POLICY_SETS_ATTR = "policySets";
    private static final String APPLICABLE_POLICYSET_ATTR_PREFIX = "tuscany";
    private static final String SCA10_NS = "http://www.osoa.org/xmlns/sca/1.0";

    public static void addInheritedIntents(List<Intent> sourceList, List<Intent> targetList) {
        if (sourceList != null) {
            targetList.addAll(sourceList);
        }
    }

    public static void addInheritedPolicySets(List<PolicySet> sourceList, List<PolicySet> targetList, boolean checkOverrides) {
        if (checkOverrides) {
            ArrayList<Intent> targetProvidedIntents = new ArrayList<Intent>();
            for (PolicySet policySet : targetList) {
                targetProvidedIntents.addAll(policySet.getProvidedIntents());
            }
            for (PolicySet policySet : sourceList) {
                for (Intent sourceProvidedIntent : policySet.getProvidedIntents()) {
                    if (targetProvidedIntents.contains(sourceProvidedIntent)) continue;
                    targetList.add(policySet);
                }
            }
        } else {
            targetList.addAll(sourceList);
        }
    }

    public static void addDefaultPolicies(List<Intent> sourceIntents, List<PolicySet> sourcePolicySets, List<Intent> targetIntents, List<PolicySet> targetPolicySets) {
        boolean conflict;
        ArrayList<Intent> combinedTargetIntents = new ArrayList<Intent>();
        combinedTargetIntents.addAll(PolicyComputationUtils.findAndExpandProfileIntents(targetIntents));
        for (PolicySet targetPolicySet : targetPolicySets) {
            combinedTargetIntents.addAll(PolicyComputationUtils.findAndExpandProfileIntents(targetPolicySet.getProvidedIntents()));
        }
        for (Intent sourceIntent : PolicyComputationUtils.findAndExpandProfileIntents(sourceIntents)) {
            conflict = false;
            for (Intent excluded : sourceIntent.getExcludedIntents()) {
                if (!combinedTargetIntents.contains(excluded)) continue;
                conflict = true;
                break;
            }
            if (conflict) continue;
            targetIntents.add(sourceIntent);
        }
        for (PolicySet sourcePolicySet : sourcePolicySets) {
            conflict = false;
            List<Intent> providedIntents = PolicyComputationUtils.findAndExpandProfileIntents(sourcePolicySet.getProvidedIntents());
            block4: for (Intent intent : providedIntents) {
                for (Intent excluded : intent.getExcludedIntents()) {
                    if (!combinedTargetIntents.contains(excluded)) continue;
                    conflict = true;
                    break block4;
                }
            }
            if (conflict) continue;
            targetPolicySets.add(sourcePolicySet);
        }
    }

    public static void checkForMutuallyExclusiveIntents(List<Intent> intents, List<PolicySet> policySets, IntentAttachPointType intentAttachPointType, String id) throws PolicyValidationException {
        HashMap<Intent, PolicySet> combinedIntents = new HashMap<Intent, PolicySet>();
        for (PolicySet policySet : policySets) {
            for (Intent providedIntent : PolicyComputationUtils.findAndExpandProfileIntents(policySet.getProvidedIntents())) {
                combinedIntents.put(providedIntent, policySet);
            }
        }
        for (Intent intent : intents) {
            combinedIntents.put(intent, null);
        }
        for (Intent intent : combinedIntents.keySet()) {
            for (Intent excluded : intent.getExcludedIntents()) {
                if (!combinedIntents.keySet().contains(excluded)) continue;
                String sIntent1 = combinedIntents.get(intent) == null ? intent.getName().toString() : intent.getName().toString() + " in policy set " + ((PolicySet)combinedIntents.get(intent)).getName().toString();
                String sIntent2 = combinedIntents.get(excluded) == null ? excluded.getName().toString() : excluded.getName().toString() + " in policy set " + ((PolicySet)combinedIntents.get(excluded)).getName().toString();
                throw new PolicyValidationException(intentAttachPointType.getName() + " for " + id + " uses mutually-exclusive intents " + sIntent1 + " and " + sIntent2);
            }
        }
    }

    public static void expandProfileIntents(List<Intent> intents) {
        List<Intent> expandedIntents = null;
        if (intents.size() > 0) {
            expandedIntents = PolicyComputationUtils.findAndExpandProfileIntents(intents);
            intents.clear();
            intents.addAll(expandedIntents);
        }
    }

    public static List<Intent> findAndExpandProfileIntents(List<Intent> intents) {
        ArrayList<Intent> expandedIntents = new ArrayList<Intent>();
        for (Intent intent : intents) {
            if (intent instanceof ProfileIntent) {
                ProfileIntent profileIntent = (ProfileIntent)intent;
                List<Intent> requiredIntents = profileIntent.getRequiredIntents();
                expandedIntents.addAll(PolicyComputationUtils.findAndExpandProfileIntents(requiredIntents));
                continue;
            }
            expandedIntents.add(intent);
        }
        return expandedIntents;
    }

    private static byte[] addApplicablePolicySets(Document doc, Collection<PolicySet> policySets) throws XPathExpressionException, TransformerConfigurationException, TransformerException {
        for (PolicySet policySet : policySets) {
            if (policySet.getAppliesTo() != null) {
                PolicyComputationUtils.addApplicablePolicySets(policySet, doc);
            }
            if (policySet.getAlwaysAppliesTo() == null) continue;
            PolicyComputationUtils.addAlwaysApplicablePolicySets(policySet, doc);
        }
        StringWriter sw = new StringWriter();
        final DOMSource domSource = new DOMSource(doc);
        final StreamResult finalResult = new StreamResult(sw);
        final Transformer transformer = TransformerFactory.newInstance().newTransformer();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws TransformerException {
                    transformer.transform(domSource, finalResult);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (TransformerException)e.getException();
        }
        return sw.toString().getBytes();
    }

    private static void addAlwaysApplicablePolicySets(PolicySet policySet, Document doc) throws XPathExpressionException {
        XPathExpression expression = policySet.getAlwaysAppliesToXPathExpression();
        NodeList result = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        if (result != null) {
            for (int counter = 0; counter < result.getLength(); ++counter) {
                Node aResultNode = result.item(counter);
                String alwaysApplicablePolicySets = null;
                String policySetPrefix = PolicyComputationUtils.declareNamespace((Element)aResultNode, policySet.getName().getNamespaceURI());
                String policySetsAttrPrefix = PolicyComputationUtils.declareNamespace((Element)aResultNode, SCA10_NS);
                if (aResultNode.getAttributes().getNamedItem(POLICY_SETS_ATTR) != null) {
                    alwaysApplicablePolicySets = aResultNode.getAttributes().getNamedItem(POLICY_SETS_ATTR).getNodeValue();
                }
                alwaysApplicablePolicySets = alwaysApplicablePolicySets != null && alwaysApplicablePolicySets.length() > 0 ? alwaysApplicablePolicySets + " " + policySetPrefix + ":" + policySet.getName().getLocalPart() : policySetPrefix + ":" + policySet.getName().getLocalPart();
                ((Element)aResultNode).setAttribute(POLICY_SETS_ATTR, alwaysApplicablePolicySets);
            }
        }
    }

    private static void addApplicablePolicySets(PolicySet policySet, Document doc) throws XPathExpressionException {
        XPathExpression expression = policySet.getAppliesToXPathExpression();
        NodeList result = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        if (result != null) {
            for (int counter = 0; counter < result.getLength(); ++counter) {
                Node aResultNode = result.item(counter);
                String applicablePolicySets = null;
                String policySetPrefix = PolicyComputationUtils.declareNamespace((Element)aResultNode, policySet.getName().getNamespaceURI());
                String appPolicyAttrPrefix = PolicyComputationUtils.declareNamespace((Element)aResultNode, APPLICABLE_POLICYSET_ATTR_NS);
                if (aResultNode.getAttributes().getNamedItemNS(APPLICABLE_POLICYSET_ATTR_NS, APPLICABLE_POLICYSET_ATTR) != null) {
                    applicablePolicySets = aResultNode.getAttributes().getNamedItemNS(APPLICABLE_POLICYSET_ATTR_NS, APPLICABLE_POLICYSET_ATTR).getNodeValue();
                }
                applicablePolicySets = applicablePolicySets != null && applicablePolicySets.length() > 0 ? applicablePolicySets + " " + policySetPrefix + ":" + policySet.getName().getLocalPart() : policySetPrefix + ":" + policySet.getName().getLocalPart();
                ((Element)aResultNode).setAttributeNS(APPLICABLE_POLICYSET_ATTR_NS, appPolicyAttrPrefix + ":" + APPLICABLE_POLICYSET_ATTR, applicablePolicySets);
            }
        }
    }

    public static byte[] addApplicablePolicySets(InputStream is, Collection<PolicySet> domainPolicySets, DocumentBuilderFactory documentBuilderFactory) throws Exception {
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder db = documentBuilderFactory.newDocumentBuilder();
        Document doc = db.parse(is);
        is.close();
        return PolicyComputationUtils.addApplicablePolicySets(doc, domainPolicySets);
    }

    private static String declareNamespace(Element element, String ns) {
        if (ns == null) {
            ns = "";
        }
        String prefix = "";
        boolean declared = false;
        for (Node node = element; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            if (node.lookupPrefix(ns) == null) continue;
            prefix = node.lookupPrefix(ns);
            declared = true;
            break;
        }
        if (!declared) {
            int i = 1;
            while (element.lookupNamespaceURI(prefix = POLICYSET_PREFIX + i) != null) {
                ++i;
            }
            String qname = "xmlns:" + prefix;
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(ns);
            element.setAttributeNodeNS(attr);
        }
        return prefix;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DOMNamespaceContext
    implements NamespaceContext {
        private Node node;

        public DOMNamespaceContext(Node node) {
            this.node = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.node.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.node.lookupPrefix(namespaceURI);
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

