/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.oasisopen.sca.ServiceRuntimeException;

public class ContributionLocationHelper {
    public static String getContributionLocation(final Class<?> anchorClass) {
        URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return anchorClass.getProtectionDomain().getCodeSource().getLocation();
            }
        });
        String uri = url.toString();
        return uri;
    }

    public static String getContributionLocation(String resourceName) {
        return ContributionLocationHelper.getContributionLocation(null, resourceName);
    }

    public static List<String> getContributionLocations(String resourceName) {
        return ContributionLocationHelper.getContributionLocations(null, resourceName);
    }

    public static String getContributionLocation(ClassLoader classLoader, String resourceName) {
        URL resourceURL;
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        if ((resourceURL = ContributionLocationHelper.getResource(classLoader, resourceName)) == null) {
            return null;
        }
        return ContributionLocationHelper.getRootLocation(resourceURL, resourceName);
    }

    public static List<String> getContributionLocations(ClassLoader classLoader, String resourceName) {
        if (classLoader == null) {
            classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        Enumeration<URL> resourceURLs = ContributionLocationHelper.getResources(classLoader, resourceName);
        ArrayList<String> locations = new ArrayList<String>();
        while (resourceURLs != null && resourceURLs.hasMoreElements()) {
            locations.add(ContributionLocationHelper.getRootLocation(resourceURLs.nextElement(), resourceName));
        }
        return locations;
    }

    private static String getRootLocation(URL resourceURL, String resourceName) {
        String location = null;
        String url = resourceURL.toExternalForm();
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            if (url.endsWith(resourceName)) {
                location = url.substring(0, url.lastIndexOf(resourceName));
            }
        } else if ("jar".equals(protocol) || "wsjar".equals(protocol) || "zip".equals(protocol)) {
            location = url.substring(protocol.length() + 1, url.lastIndexOf("!/"));
        } else if (url.endsWith(resourceName)) {
            location = url.substring(0, url.lastIndexOf(resourceName));
        } else {
            throw new IllegalArgumentException("The root of the resource cannot be determined: " + resourceURL + "," + resourceName);
        }
        return location;
    }

    private static URL getResource(final ClassLoader classLoader, final String compositeURI) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return classLoader.getResource(compositeURI);
            }
        });
    }

    private static Enumeration<URL> getResources(final ClassLoader classLoader, final String compositeURI) {
        return AccessController.doPrivileged(new PrivilegedAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() {
                try {
                    return classLoader.getResources(compositeURI);
                }
                catch (IOException e) {
                    throw new ServiceRuntimeException((Throwable)e);
                }
            }
        });
    }
}

