/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.node;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.node.Contribution;
import org.apache.tuscany.sca.node.ContributionLocationHelper;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.configuration.DefaultNodeConfigurationFactory;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.node.extensibility.NodeExtension;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public abstract class NodeFactory
extends DefaultNodeConfigurationFactory {
    private static final String SCA_CONTRIBUTION_META = "META-INF/sca-contribution.xml";
    private static final String SCA_CONTRIBUTION_GENERATED_META = "META-INF/sca-contribution-generated.xml";
    protected static NodeFactory instance;
    protected static Class<?> factoryImplClass;
    protected static List<NodeFactory> factories;
    protected Properties properties = new Properties();
    private static int count;

    protected static void setNodeFactory(NodeFactory factory) {
        instance = factory;
    }

    public static synchronized NodeFactory getInstance() {
        if (instance == null) {
            instance = NodeFactory.newInstance();
        }
        return instance;
    }

    public static NodeFactory newInstance() {
        NodeFactory nodeFactory = null;
        try {
            Class<?> factoryClass = NodeFactory.getFactoryImplClass();
            nodeFactory = (NodeFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        factories.add(nodeFactory);
        return nodeFactory;
    }

    public static NodeFactory newInstance(Map<String, Map<String, String>> attributes) {
        NodeFactory nodeFactory = null;
        try {
            Class<?> factoryClass = NodeFactory.getFactoryImplClass();
            nodeFactory = (NodeFactory)factoryClass.newInstance();
            nodeFactory.configure(attributes);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        factories.add(nodeFactory);
        return nodeFactory;
    }

    protected NodeFactory() {
    }

    public static NodeFactory newInstance(Properties configProperties) {
        NodeFactory nodeFactory = null;
        try {
            Class<?> factoryClass = NodeFactory.getFactoryImplClass();
            nodeFactory = (NodeFactory)factoryClass.newInstance();
            nodeFactory.properties = configProperties;
            nodeFactory.configure(new HashMap<String, Map<String, String>>());
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
        factories.add(nodeFactory);
        return nodeFactory;
    }

    public static NodeFactory newInstance(String configURI) {
        Properties properties;
        if (configURI == null || configURI.length() < 1) {
            return NodeFactory.newInstance();
        }
        if (configURI.startsWith("properties:")) {
            try {
                properties = NodeFactory.loadProperties(configURI.substring("properties:".length()));
            }
            catch (IOException e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        } else if (configURI.startsWith("uri:")) {
            properties = NodeFactory.parseConfigURI(configURI.substring("uri:".length()));
        } else {
            properties = new Properties();
            properties.setProperty("defaultDomainName", configURI);
        }
        return NodeFactory.newInstance(properties);
    }

    private static Properties parseConfigURI(String configURI) {
        Properties properties = new Properties();
        int qm = configURI.indexOf(63);
        if (qm < 0) {
            properties.setProperty("defaultDomainName", configURI);
        } else {
            if (qm == 0) {
                properties.setProperty("defaultDomainName", "default");
            } else {
                properties.setProperty("defaultDomainName", configURI.substring(0, qm));
            }
            if (configURI.length() > qm + 1) {
                HashMap<String, String> params = new HashMap<String, String>();
                for (String param : configURI.substring(qm + 1).split("&")) {
                    String[] px = param.split("=");
                    if (px.length == 2) {
                        params.put(px[0], px[1]);
                        continue;
                    }
                    params.put(px[0], "");
                }
                for (String name : params.keySet()) {
                    properties.setProperty(name, (String)params.get(name));
                }
            }
        }
        return properties;
    }

    private static Properties loadProperties(String propsURL) throws IOException {
        Properties properties = new Properties();
        File file = new File(propsURL);
        InputStream inputStream = null;
        if (file.exists()) {
            inputStream = new FileInputStream(file);
        } else {
            URL url;
            block6: {
                url = null;
                try {
                    url = new URL(propsURL);
                }
                catch (MalformedURLException e) {
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsURL);
                    if (inputStream != null) break block6;
                    throw new IOException("File does not exist: " + propsURL + ", could not be found on the classpath and is not a valid URL: " + e);
                }
            }
            if (inputStream == null && url != null) {
                inputStream = url.openStream();
            }
        }
        if (inputStream != null) {
            properties.load(inputStream);
            inputStream.close();
        }
        return properties;
    }

    public void configure(Map<String, Map<String, String>> attributes) {
    }

    private static synchronized Class<?> getFactoryImplClass() throws Exception {
        if (factoryImplClass == null) {
            try {
                Class<?> discoveryClass = Class.forName("org.apache.tuscany.sca.extensibility.ServiceDiscovery");
                Object instance = discoveryClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                Object factoryDeclaration = discoveryClass.getMethod("getServiceDeclaration", Class.class).invoke(instance, NodeFactory.class);
                if (factoryDeclaration != null) {
                    factoryImplClass = (Class)factoryDeclaration.getClass().getMethod("loadClass", new Class[0]).invoke(factoryDeclaration, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (factoryImplClass == null) {
                String className = "org.apache.tuscany.sca.node.impl.NodeFactoryImpl";
                factoryImplClass = Class.forName(className);
            }
        }
        return factoryImplClass;
    }

    private static InputStream openStream(URL url) throws IOException {
        InputStream is = null;
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        is = connection.getInputStream();
        return is;
    }

    private static URI createURI(String uri) {
        int index = uri.indexOf(58);
        String scheme = null;
        String ssp = uri;
        if (index != -1) {
            scheme = uri.substring(0, index);
            ssp = uri.substring(index + 1);
        }
        try {
            return new URI(scheme, ssp, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Node createNode(URL configurationURL) {
        try {
            InputStream is = NodeFactory.openStream(configurationURL);
            NodeConfiguration configuration = this.loadConfiguration(is, configurationURL);
            return this.createNode(configuration);
        }
        catch (IOException e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    public Node createNode(InputStream is) {
        NodeConfiguration configuration = this.loadConfiguration(is, null);
        return this.createNode(configuration);
    }

    public Node createNode(String deploymentCompositeURI, Contribution ... contributions) {
        if (contributions == null || contributions.length == 0) {
            if (deploymentCompositeURI == null || deploymentCompositeURI.indexOf(58) != -1) {
                throw new ServiceRuntimeException("No SCA contribution is provided or discovered");
            }
            List<String> locations = ContributionLocationHelper.getContributionLocations(null, deploymentCompositeURI);
            if (locations.isEmpty()) {
                throw new ServiceRuntimeException("No SCA contributions are found on the classpath");
            }
            contributions = this.getContributions(locations);
        }
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (deploymentCompositeURI != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(NodeFactory.createURI(deploymentCompositeURI));
        }
        return this.createNode(configuration);
    }

    public final Node createNode(URI domainRegistryURI, String ... locations) {
        return this.createNode(domainRegistryURI, (String)null, locations);
    }

    public final Node createNode(URI domainRegistryURI, String deploymentCompositeURI, String[] locations) {
        Contribution[] contributions = this.getContributions(Arrays.asList(locations));
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (deploymentCompositeURI != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(NodeFactory.createURI(deploymentCompositeURI));
        }
        configuration.setDomainRegistryURI(domainRegistryURI.toString());
        configuration.setDomainURI(NodeFactory.getDomainURI(domainRegistryURI));
        return this.createNode(configuration);
    }

    public static String getDomainURI(URI configURI) {
        String s = configURI.getHost();
        if (s == null && (s = configURI.getSchemeSpecificPart()) != null && s.indexOf(63) > -1) {
            s = s.substring(0, s.indexOf(63));
        }
        return s;
    }

    public final Node createNode(String deploymentCompositeURI, String[] uris, String[] locations) {
        return this.createNode(deploymentCompositeURI, this.getContributions(Arrays.asList(uris), Arrays.asList(locations)));
    }

    public final Node createNode(String deploymentCompositeURI, String[] locations) {
        return this.createNode(deploymentCompositeURI, this.getContributions(Arrays.asList(locations)));
    }

    public final Node createNode(Reader deploymentCompositeContent, String[] uris, String[] locations) {
        return this.createNode(deploymentCompositeContent, this.getContributions(Arrays.asList(uris), Arrays.asList(locations)));
    }

    public final Node createNode(String compositeURI, ClassLoader classLoader) {
        List<String> locations = ContributionLocationHelper.getContributionLocations(classLoader, compositeURI);
        return this.createNode(compositeURI, locations.toArray(new String[locations.size()]));
    }

    public Node createNode(Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        return this.createNode(configuration);
    }

    public Node createNode(InputStream compositeContent, Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (compositeContent != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(compositeContent);
        }
        return this.createNode(configuration);
    }

    public Node createNode(Reader compositeContent, Contribution ... contributions) {
        NodeConfiguration configuration = this.createConfiguration(contributions);
        if (compositeContent != null && configuration.getContributions().size() > 0) {
            configuration.getContributions().get(0).addDeploymentComposite(compositeContent);
        }
        return this.createNode(configuration);
    }

    public Node createNode() {
        ArrayList<String> locations = new ArrayList<String>();
        locations.addAll(ContributionLocationHelper.getContributionLocations(null, SCA_CONTRIBUTION_META));
        locations.addAll(ContributionLocationHelper.getContributionLocations(null, SCA_CONTRIBUTION_GENERATED_META));
        if (locations.isEmpty()) {
            throw new ServiceRuntimeException("No SCA contributions are found on the classpath");
        }
        Contribution[] contributions = this.getContributions(locations);
        return this.createNode(contributions);
    }

    private NodeConfiguration createConfiguration(Contribution ... contributions) {
        NodeFactory factory = this;
        NodeConfiguration configuration = factory.createNodeConfiguration();
        if (this.properties.getProperty("defaultDomainName") != null) {
            configuration.setDomainURI(this.properties.getProperty("defaultDomainName"));
        }
        configuration.setURI(this.generateNodeURI());
        if (contributions != null) {
            for (Contribution c : contributions) {
                configuration.addContribution(c.getURI(), c.getLocation());
            }
        }
        return configuration;
    }

    protected synchronized String generateNodeURI() {
        return "http://tuscany.apache.org/sca/1.1/nodes/default" + count++;
    }

    private Contribution[] getContributions(List<String> locations) {
        Contribution[] contributions = new Contribution[locations.size()];
        int index = 0;
        for (String location : locations) {
            contributions[index++] = new Contribution(location, location);
        }
        return contributions;
    }

    private Contribution[] getContributions(List<String> uris, List<String> locations) {
        if (uris.size() != locations.size()) {
            throw new IllegalArgumentException("The number of URIs does not match the number of locations");
        }
        Contribution[] contributions = new Contribution[locations.size()];
        int n = locations.size();
        for (int i = 0; i < n; ++i) {
            contributions[i] = new Contribution(uris.get(i), locations.get(i));
        }
        return contributions;
    }

    public void destroy() {
        count = 0;
        instance = null;
        factories.remove(this);
    }

    public static List<NodeFactory> getNodeFactories() {
        return factories;
    }

    public abstract Node createNode(NodeConfiguration var1);

    public abstract Node createNode(List<?> var1);

    public abstract NodeConfiguration loadConfiguration(InputStream var1, URL var2);

    public abstract ExtensionPointRegistry getExtensionPointRegistry();

    public abstract void init();

    public abstract void setAutoDestroy(boolean var1);

    public abstract NodeExtension loadNode(NodeConfiguration var1);

    static {
        factories = new ArrayList<NodeFactory>();
        count = 0;
    }

    public static class NodeProxy
    implements Node {
        private Object node;

        private NodeProxy(Object node) {
            this.node = node;
        }

        public static <T> T createProxy(Class<T> type, Object node) {
            try {
                return type.getDeclaredConstructor(Object.class).newInstance(node);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
            try {
                return (R)((ServiceReference)this.node.getClass().getMethod("cast", Object.class).invoke(this.node, target));
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> B getService(Class<B> businessInterface, String serviceName) {
            try {
                return (B)this.node.getClass().getMethod("getService", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public <B> ServiceReference<B> getServiceReference(Class<B> businessInterface, String serviceName) {
            try {
                return (ServiceReference)this.node.getClass().getMethod("getServiceReference", Class.class, String.class).invoke(this.node, businessInterface, serviceName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public Node start() {
            try {
                return new NodeProxy(this.node.getClass().getMethod("start", new Class[0]).invoke(this.node, new Object[0]));
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }

        @Override
        public void stop() {
            try {
                this.node.getClass().getMethod("stop", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        public void destroy() {
            try {
                this.node.getClass().getMethod("destroy", new Class[0]).invoke(this.node, new Object[0]);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
            }
        }

        private static void handleException(Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            throw new RuntimeException(ex);
        }

        @Override
        public String getEndpointAddress(String serviceBindingName) {
            try {
                return (String)this.node.getClass().getMethod("getEndpointAddress", String.class).invoke(this.node, serviceBindingName);
            }
            catch (Throwable e) {
                NodeProxy.handleException(e);
                return null;
            }
        }
    }
}

