/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.TuscanyRuntime;

public class TuscanyStartMojo
extends AbstractMojo {
    public static Map<String, TuscanyRuntime> runtimes = new HashMap<String, TuscanyRuntime>();
    private MavenProject project;
    protected String artifactId;
    protected String packaging;
    protected File buildDirectory;
    protected File finalName;
    private String id;
    private String domainURI;
    private String nodeConfig;
    private String[] contributions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Starting Tuscany Runtime...");
        TuscanyRuntime runtime = TuscanyRuntime.newInstance();
        runtimes.put(this.id, runtime);
        if (this.nodeConfig != null && this.nodeConfig.length() > 0) {
            try {
                runtime.createNodeFromXML(this.nodeConfig);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception creating node", e);
            }
        }
        ArrayList<String> contributionList = new ArrayList<String>();
        this.addProjectContribution(contributionList);
        this.addAdditionalContributions(contributionList);
        Node node = runtime.createNode(this.domainURI);
        for (String c : contributionList) {
            String curi;
            try {
                curi = node.installContribution(null, c, null, null);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception installing contribution", e);
            }
            try {
                node.startDeployables(curi);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception starting deployables for contribution " + curi, e);
            }
        }
    }

    private void addAdditionalContributions(List<String> contributionList) throws MojoExecutionException {
        if (this.contributions != null) {
            for (String s : this.contributions) {
                if (new File(s).exists()) {
                    contributionList.add(s);
                    continue;
                }
                boolean found = false;
                for (Object o : this.project.getDependencyArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (!a.getId().startsWith(s)) continue;
                    try {
                        contributionList.add(a.getFile().toURI().toURL().toString());
                    }
                    catch (MalformedURLException e) {
                        throw new MojoExecutionException("", (Exception)e);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Contribution not found as file or dependency: " + s);
            }
        }
    }

    protected void addProjectContribution(List<String> cs) throws MojoExecutionException {
        try {
            File contributionFile = new File(this.buildDirectory.getParent(), this.finalName.getName());
            if (!contributionFile.exists()) {
                contributionFile = new File(this.buildDirectory.getParent(), "classes");
            }
            if (!contributionFile.exists()) {
                contributionFile = new File(this.buildDirectory.getParent(), this.finalName.getName() + this.packaging);
            }
            String contribution = contributionFile.toURI().toURL().toString();
            this.getLog().info((CharSequence)("Project contribution: " + contribution));
            cs.add(contribution);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

