/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.maven.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.Tomcat;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tuscany.sca.shell.Shell;

public class TuscanyRunMojo
extends AbstractMojo {
    private MavenProject project;
    protected String artifactId;
    protected String packaging;
    protected File buildDirectory;
    protected File finalName;
    private String domainURI;
    private String nodeXML;
    private String[] contributions;
    private String mainClass;
    private String[] arguments;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.mainClass != null) {
            this.executeMainMethod();
        } else if (".war".equals(this.packaging)) {
            try {
                this.executeTomcat();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception running Tuscany/Tomcat", e);
            }
        } else {
            this.executeShell();
        }
    }

    private void executeTomcat() throws ServletException, LifecycleException, MalformedURLException {
        this.getLog().info((CharSequence)"Starting Tuscany/Tomcat...");
        Tomcat tomcat = new Tomcat();
        tomcat.setPort(8080);
        tomcat.setBaseDir("target");
        String appBase = "../src/main/webapp";
        tomcat.getHost().setAppBase(".");
        String contextPath = "/" + this.artifactId;
        StandardServer server = (StandardServer)tomcat.getServer();
        server.setParentClassLoader(this.getMainClassLoader());
        AprLifecycleListener listener = new AprLifecycleListener();
        server.addLifecycleListener((LifecycleListener)listener);
        tomcat.addWebapp(contextPath, appBase);
        tomcat.start();
        tomcat.getServer().await();
    }

    private void executeShell() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Starting Tuscany Shell...");
        if (this.nodeXML != null && this.nodeXML.length() > 0) {
            try {
                Shell.main((String[])new String[]{"-nodeXML:" + this.nodeXML});
            }
            catch (Exception e) {
                throw new MojoExecutionException("Exception in Shell", e);
            }
        }
        ArrayList<String> contributionList = new ArrayList<String>();
        this.addProjectContribution(contributionList);
        this.addAdditionalContributions(contributionList);
        contributionList.add(0, "-help");
        contributionList.add(0, this.domainURI);
        try {
            Shell.main((String[])contributionList.toArray(new String[contributionList.size()]));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception in Shell", e);
        }
        this.getLog().info((CharSequence)"Tuscany Shell stopped.");
    }

    private void addAdditionalContributions(List<String> contributionList) throws MojoExecutionException {
        if (this.contributions != null) {
            for (String s : this.contributions) {
                if (new File(s).exists()) {
                    contributionList.add(s);
                    continue;
                }
                boolean found = false;
                for (Object o : this.project.getDependencyArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (!a.getId().startsWith(s)) continue;
                    try {
                        contributionList.add(a.getFile().toURI().toURL().toString());
                    }
                    catch (MalformedURLException e) {
                        throw new MojoExecutionException("", (Exception)e);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Contribution not found as file or dependency: " + s);
            }
        }
    }

    protected void addProjectContribution(List<String> cs) throws MojoExecutionException {
        try {
            File contributionFile = new File(this.buildDirectory.getParent(), this.finalName.getName());
            if (!contributionFile.exists()) {
                contributionFile = new File(this.buildDirectory.getParent(), "classes");
            }
            if (!contributionFile.exists()) {
                contributionFile = new File(this.buildDirectory.getParent(), this.finalName.getName() + this.packaging);
            }
            String contribution = contributionFile.toURI().toURL().toString();
            this.getLog().info((CharSequence)("Project contribution: " + contribution));
            cs.add(contribution);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }

    public void executeMainMethod() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Invoking " + this.mainClass + " class main method..."));
        if (this.arguments == null) {
            this.arguments = new String[0];
        }
        try {
            Method main = this.getMainClassLoader().loadClass(this.mainClass).getMethod("main", String[].class);
            main.invoke((Object)main, new Object[]{this.arguments});
        }
        catch (NoSuchMethodException e) {
            throw new MojoExecutionException("The specified mainClass doesn't contain a main method with appropriate signature", (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("exception invoking main method", e);
        }
    }

    private ClassLoader getMainClassLoader() throws MalformedURLException {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> classPathEntries = new ArrayList<URL>();
        classPathEntries.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
        for (Object o : this.project.getRuntimeArtifacts()) {
            Artifact a = (Artifact)o;
            classPathEntries.add(a.getFile().toURI().toURL());
        }
        return new URLClassLoader(classPathEntries.toArray(new URL[0]), parent);
    }
}

