/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaInterfaceUtil {
    private JavaInterfaceUtil() {
    }

    public static Method findMethod(Class<?> implClass, Operation operation) throws NoSuchMethodException {
        String name = operation.getName();
        if (operation instanceof JavaOperation) {
            name = ((JavaOperation)operation).getJavaMethod().getName();
        }
        Interface interface1 = operation.getInterface();
        int numParams = ((List)operation.getInputType().getLogical()).size();
        if (interface1 != null && interface1.isRemotable()) {
            ArrayList<Method> matchingMethods = new ArrayList<Method>();
            for (Method m : implClass.getMethods()) {
                if (!m.getName().equals(name) || m.getParameterTypes().length != numParams) continue;
                matchingMethods.add(m);
            }
            if (matchingMethods.size() == 1) {
                return (Method)matchingMethods.get(0);
            }
            if (matchingMethods.size() > 1) {
                Class<?>[] paramTypes = JavaInterfaceUtil.getPhysicalTypes(operation);
                return implClass.getMethod(name, paramTypes);
            }
            throw new NoSuchMethodException("No matching method for operation " + operation.getName() + " is found on " + implClass);
        }
        Class<?>[] paramTypes = JavaInterfaceUtil.getPhysicalTypes(operation);
        return implClass.getMethod(name, paramTypes);
    }

    private static Class<?>[] getPhysicalTypes(Operation operation) {
        DataType inputType = operation.getInputType();
        if (inputType == null) {
            return new Class[0];
        }
        List types = (List)inputType.getLogical();
        Class[] javaTypes = new Class[types.size()];
        for (int i = 0; i < javaTypes.length; ++i) {
            Class physical = ((DataType)types.get(i)).getPhysical();
            if (!(physical instanceof Class)) {
                throw new UnsupportedOperationException();
            }
            javaTypes[i] = physical;
        }
        return javaTypes;
    }

    public static Operation findOperation(Method method, Collection<Operation> operations) {
        for (Operation operation : operations) {
            if (!JavaInterfaceUtil.match(operation, method)) continue;
            return operation;
        }
        return null;
    }

    private static boolean match(Operation operation, Method method) {
        Class<?>[] params = method.getParameterTypes();
        DataType inputType = operation.getInputType();
        List types = (List)inputType.getLogical();
        boolean found = true;
        if (types.size() == params.length && method.getName().equals(operation.getName())) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> clazz = params[i];
                if (clazz.equals(((DataType)((List)operation.getInputType().getLogical()).get(i)).getPhysical())) continue;
                found = false;
            }
        } else {
            found = false;
        }
        return found;
    }

    private static String getPackageName(Class<?> cls) {
        String name = cls.getName();
        int index = name.lastIndexOf(46);
        return index == -1 ? "" : name.substring(0, index);
    }

    public static String getNamespace(Class<?> cls) {
        String packageName = JavaInterfaceUtil.getPackageName(cls);
        if ("".equals(packageName)) {
            return "";
        }
        StringBuffer ns = new StringBuffer("http://");
        String[] names = packageName.split("\\.");
        for (int i = names.length - 1; i >= 0; --i) {
            ns.append(names[i]);
            if (i == 0) continue;
            ns.append('.');
        }
        ns.append('/');
        return ns.toString();
    }
}

